/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VpcClassicLinkIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcClassicLinkRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkRequest> {
    private final List<Filter> filters;
    private final List<String> vpcIds;

    private DescribeVpcClassicLinkRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.vpcIds = builder.vpcIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> vpcIds() {
        return this.vpcIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.vpcIds() == null ? 0 : this.vpcIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkRequest)) {
            return false;
        }
        DescribeVpcClassicLinkRequest other = (DescribeVpcClassicLinkRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.vpcIds() == null ^ this.vpcIds() == null) {
            return false;
        }
        return other.vpcIds() == null || other.vpcIds().equals(this.vpcIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.vpcIds() != null) {
            sb.append("VpcIds: ").append(this.vpcIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "VpcIds": {
                return Optional.of(clazz.cast(this.vpcIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> vpcIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkRequest model) {
            this.filters(model.filters);
            this.vpcIds(model.vpcIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpcIds() {
            return this.vpcIds;
        }

        @Override
        public final Builder vpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIds(String ... vpcIds) {
            this.vpcIds(Arrays.asList(vpcIds));
            return this;
        }

        public final void setVpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
        }

        public DescribeVpcClassicLinkRequest build() {
            return new DescribeVpcClassicLinkRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcClassicLinkRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder vpcIds(Collection<String> var1);

        public Builder vpcIds(String ... var1);
    }
}

