/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.HistoryRecord;
import software.amazon.awssdk.services.ec2.model.HistoryRecordsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotFleetRequestHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
    private final List<HistoryRecord> historyRecords;
    private final Instant lastEvaluatedTime;
    private final String nextToken;
    private final String spotFleetRequestId;
    private final Instant startTime;

    private DescribeSpotFleetRequestHistoryResponse(BuilderImpl builder) {
        this.historyRecords = builder.historyRecords;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.startTime = builder.startTime;
    }

    public List<HistoryRecord> historyRecords() {
        return this.historyRecords;
    }

    public Instant lastEvaluatedTime() {
        return this.lastEvaluatedTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.historyRecords() == null ? 0 : this.historyRecords().hashCode());
        hashCode = 31 * hashCode + (this.lastEvaluatedTime() == null ? 0 : this.lastEvaluatedTime().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestId() == null ? 0 : this.spotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestHistoryResponse)) {
            return false;
        }
        DescribeSpotFleetRequestHistoryResponse other = (DescribeSpotFleetRequestHistoryResponse)((Object)obj);
        if (other.historyRecords() == null ^ this.historyRecords() == null) {
            return false;
        }
        if (other.historyRecords() != null && !other.historyRecords().equals(this.historyRecords())) {
            return false;
        }
        if (other.lastEvaluatedTime() == null ^ this.lastEvaluatedTime() == null) {
            return false;
        }
        if (other.lastEvaluatedTime() != null && !other.lastEvaluatedTime().equals(this.lastEvaluatedTime())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        return other.startTime() == null || other.startTime().equals(this.startTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.historyRecords() != null) {
            sb.append("HistoryRecords: ").append(this.historyRecords()).append(",");
        }
        if (this.lastEvaluatedTime() != null) {
            sb.append("LastEvaluatedTime: ").append(this.lastEvaluatedTime()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(this.spotFleetRequestId()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HistoryRecords": {
                return Optional.of(clazz.cast(this.historyRecords()));
            }
            case "LastEvaluatedTime": {
                return Optional.of(clazz.cast(this.lastEvaluatedTime()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "SpotFleetRequestId": {
                return Optional.of(clazz.cast(this.spotFleetRequestId()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<HistoryRecord> historyRecords;
        private Instant lastEvaluatedTime;
        private String nextToken;
        private String spotFleetRequestId;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestHistoryResponse model) {
            this.historyRecords(model.historyRecords);
            this.lastEvaluatedTime(model.lastEvaluatedTime);
            this.nextToken(model.nextToken);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.startTime(model.startTime);
        }

        public final Collection<HistoryRecord.Builder> getHistoryRecords() {
            return this.historyRecords != null ? (Collection)this.historyRecords.stream().map(HistoryRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder historyRecords(Collection<HistoryRecord> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copy(historyRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(HistoryRecord ... historyRecords) {
            this.historyRecords(Arrays.asList(historyRecords));
            return this;
        }

        public final void setHistoryRecords(Collection<HistoryRecord.BuilderImpl> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copyFromBuilder(historyRecords);
        }

        public final Instant getLastEvaluatedTime() {
            return this.lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final void setLastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public DescribeSpotFleetRequestHistoryResponse build() {
            return new DescribeSpotFleetRequestHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
        public Builder historyRecords(Collection<HistoryRecord> var1);

        public Builder historyRecords(HistoryRecord ... var1);

        public Builder lastEvaluatedTime(Instant var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestId(String var1);

        public Builder startTime(Instant var1);
    }
}

