/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.GroupIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSecurityGroupReferencesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSecurityGroupReferencesRequest> {
    private final List<String> groupId;

    private DescribeSecurityGroupReferencesRequest(BuilderImpl builder) {
        this.groupId = builder.groupId;
    }

    public List<String> groupId() {
        return this.groupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesRequest)) {
            return false;
        }
        DescribeSecurityGroupReferencesRequest other = (DescribeSecurityGroupReferencesRequest)((Object)obj);
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        return other.groupId() == null || other.groupId().equals(this.groupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupReferencesRequest model) {
            this.groupId(model.groupId);
        }

        public final Collection<String> getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(Collection<String> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupId(String ... groupId) {
            this.groupId(Arrays.asList(groupId));
            return this;
        }

        public final void setGroupId(Collection<String> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
        }

        public DescribeSecurityGroupReferencesRequest build() {
            return new DescribeSecurityGroupReferencesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSecurityGroupReferencesRequest> {
        public Builder groupId(Collection<String> var1);

        public Builder groupId(String ... var1);
    }
}

