/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.CustomerGatewayIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCustomerGatewaysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeCustomerGatewaysRequest> {
    private final List<String> customerGatewayIds;
    private final List<Filter> filters;

    private DescribeCustomerGatewaysRequest(BuilderImpl builder) {
        this.customerGatewayIds = builder.customerGatewayIds;
        this.filters = builder.filters;
    }

    public List<String> customerGatewayIds() {
        return this.customerGatewayIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.customerGatewayIds() == null ? 0 : this.customerGatewayIds().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysRequest)) {
            return false;
        }
        DescribeCustomerGatewaysRequest other = (DescribeCustomerGatewaysRequest)((Object)obj);
        if (other.customerGatewayIds() == null ^ this.customerGatewayIds() == null) {
            return false;
        }
        if (other.customerGatewayIds() != null && !other.customerGatewayIds().equals(this.customerGatewayIds())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        return other.filters() == null || other.filters().equals(this.filters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.customerGatewayIds() != null) {
            sb.append("CustomerGatewayIds: ").append(this.customerGatewayIds()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGatewayIds": {
                return Optional.of(clazz.cast(this.customerGatewayIds()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> customerGatewayIds;
        private List<Filter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysRequest model) {
            this.customerGatewayIds(model.customerGatewayIds);
            this.filters(model.filters);
        }

        public final Collection<String> getCustomerGatewayIds() {
            return this.customerGatewayIds;
        }

        @Override
        public final Builder customerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGatewayIds(String ... customerGatewayIds) {
            this.customerGatewayIds(Arrays.asList(customerGatewayIds));
            return this;
        }

        public final void setCustomerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public DescribeCustomerGatewaysRequest build() {
            return new DescribeCustomerGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCustomerGatewaysRequest> {
        public Builder customerGatewayIds(Collection<String> var1);

        public Builder customerGatewayIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);
    }
}

