/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlacementGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePlacementGroupRequest> {
    private final String groupName;
    private final String strategy;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
    }

    public String groupName() {
        return this.groupName;
    }

    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(this.strategy);
    }

    public String strategyString() {
        return this.strategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.strategyString() == null ? 0 : this.strategyString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest)((Object)obj);
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.strategyString() == null ^ this.strategyString() == null) {
            return false;
        }
        return other.strategyString() == null || other.strategyString().equals(this.strategyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.strategyString() != null) {
            sb.append("Strategy: ").append(this.strategyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "Strategy": {
                return Optional.of(clazz.cast(this.strategyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            this.groupName(model.groupName);
            this.strategy(model.strategy);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        public Builder groupName(String var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);
    }
}

