/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachNetworkInterfaceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachNetworkInterfaceRequest> {
    private final Integer deviceIndex;
    private final String instanceId;
    private final String networkInterfaceId;

    private AttachNetworkInterfaceRequest(BuilderImpl builder) {
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deviceIndex() == null ? 0 : this.deviceIndex().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachNetworkInterfaceRequest)) {
            return false;
        }
        AttachNetworkInterfaceRequest other = (AttachNetworkInterfaceRequest)((Object)obj);
        if (other.deviceIndex() == null ^ this.deviceIndex() == null) {
            return false;
        }
        if (other.deviceIndex() != null && !other.deviceIndex().equals(this.deviceIndex())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        return other.networkInterfaceId() == null || other.networkInterfaceId().equals(this.networkInterfaceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(this.deviceIndex()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceIndex": {
                return Optional.of(clazz.cast(this.deviceIndex()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer deviceIndex;
        private String instanceId;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachNetworkInterfaceRequest model) {
            this.deviceIndex(model.deviceIndex);
            this.instanceId(model.instanceId);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public AttachNetworkInterfaceRequest build() {
            return new AttachNetworkInterfaceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachNetworkInterfaceRequest> {
        public Builder deviceIndex(Integer var1);

        public Builder instanceId(String var1);

        public Builder networkInterfaceId(String var1);
    }
}

