/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateHostsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AllocateHostsResponse> {
    private final List<String> hostIds;

    private AllocateHostsResponse(BuilderImpl builder) {
        this.hostIds = builder.hostIds;
    }

    public List<String> hostIds() {
        return this.hostIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostIds() == null ? 0 : this.hostIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsResponse)) {
            return false;
        }
        AllocateHostsResponse other = (AllocateHostsResponse)((Object)obj);
        if (other.hostIds() == null ^ this.hostIds() == null) {
            return false;
        }
        return other.hostIds() == null || other.hostIds().equals(this.hostIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostIds() != null) {
            sb.append("HostIds: ").append(this.hostIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostIds": {
                return Optional.of(clazz.cast(this.hostIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> hostIds;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsResponse model) {
            this.hostIds(model.hostIds);
        }

        public final Collection<String> getHostIds() {
            return this.hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = ResponseHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = ResponseHostIdListCopier.copy(hostIds);
        }

        public AllocateHostsResponse build() {
            return new AllocateHostsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AllocateHostsResponse> {
        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);
    }
}

