/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeReservedInstancesListingsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeReservedInstancesListingsRequestMarshaller implements
        Marshaller<Request<DescribeReservedInstancesListingsRequest>, DescribeReservedInstancesListingsRequest> {

    public Request<DescribeReservedInstancesListingsRequest> marshall(
            DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) {

        if (describeReservedInstancesListingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeReservedInstancesListingsRequest> request = new DefaultRequest<DescribeReservedInstancesListingsRequest>(
                describeReservedInstancesListingsRequest, "EC2Client");
        request.addParameter("Action", "DescribeReservedInstancesListings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeReservedInstancesListingsRequestFiltersList = describeReservedInstancesListingsRequest
                .filters();
        if (describeReservedInstancesListingsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeReservedInstancesListingsRequestFiltersListValue : describeReservedInstancesListingsRequestFiltersList) {

                if (describeReservedInstancesListingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeReservedInstancesListingsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeReservedInstancesListingsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeReservedInstancesListingsRequest.reservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId",
                    StringUtils.fromString(describeReservedInstancesListingsRequest.reservedInstancesId()));
        }

        if (describeReservedInstancesListingsRequest.reservedInstancesListingId() != null) {
            request.addParameter("ReservedInstancesListingId",
                    StringUtils.fromString(describeReservedInstancesListingsRequest.reservedInstancesListingId()));
        }

        return request;
    }

}
