/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeNetworkInterfaceAttributeResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNetworkInterfaceAttributeResponseUnmarshaller implements
        Unmarshaller<DescribeNetworkInterfaceAttributeResponse, StaxUnmarshallerContext> {

    public DescribeNetworkInterfaceAttributeResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeNetworkInterfaceAttributeResponse.Builder describeNetworkInterfaceAttributeResponse = DescribeNetworkInterfaceAttributeResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<GroupIdentifier> groups = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeNetworkInterfaceAttributeResponse.groups(groups);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("attachment", targetDepth)) {
                    describeNetworkInterfaceAttributeResponse.attachment(NetworkInterfaceAttachmentUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("description", targetDepth)) {
                    describeNetworkInterfaceAttributeResponse.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupSet", targetDepth)) {
                    groups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    describeNetworkInterfaceAttributeResponse.networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("sourceDestCheck", targetDepth)) {
                    describeNetworkInterfaceAttributeResponse.sourceDestCheck(BooleanUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeNetworkInterfaceAttributeResponse.groups(groups);
                    break;
                }
            }
        }
        return describeNetworkInterfaceAttributeResponse.build();
    }

    private static final DescribeNetworkInterfaceAttributeResponseUnmarshaller INSTANCE = new DescribeNetworkInterfaceAttributeResponseUnmarshaller();

    public static DescribeNetworkInterfaceAttributeResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
