/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeClassicLinkInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeClassicLinkInstancesRequestMarshaller implements
        Marshaller<Request<DescribeClassicLinkInstancesRequest>, DescribeClassicLinkInstancesRequest> {

    public Request<DescribeClassicLinkInstancesRequest> marshall(
            DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {

        if (describeClassicLinkInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeClassicLinkInstancesRequest> request = new DefaultRequest<DescribeClassicLinkInstancesRequest>(
                describeClassicLinkInstancesRequest, "EC2Client");
        request.addParameter("Action", "DescribeClassicLinkInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeClassicLinkInstancesRequestFiltersList = describeClassicLinkInstancesRequest.filters();
        if (describeClassicLinkInstancesRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeClassicLinkInstancesRequestFiltersListValue : describeClassicLinkInstancesRequestFiltersList) {

                if (describeClassicLinkInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeClassicLinkInstancesRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeClassicLinkInstancesRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        java.util.List<String> describeClassicLinkInstancesRequestInstanceIdsList = describeClassicLinkInstancesRequest
                .instanceIds();
        if (describeClassicLinkInstancesRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;

            for (String describeClassicLinkInstancesRequestInstanceIdsListValue : describeClassicLinkInstancesRequestInstanceIdsList) {
                if (describeClassicLinkInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex,
                            StringUtils.fromString(describeClassicLinkInstancesRequestInstanceIdsListValue));
                }
                instanceIdsListIndex++;
            }
        }

        if (describeClassicLinkInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeClassicLinkInstancesRequest.maxResults()));
        }

        if (describeClassicLinkInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeClassicLinkInstancesRequest.nextToken()));
        }

        return request;
    }

}
