/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeAccountAttributesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeAccountAttributesResponseUnmarshaller implements
        Unmarshaller<DescribeAccountAttributesResponse, StaxUnmarshallerContext> {

    public DescribeAccountAttributesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeAccountAttributesResponse.Builder describeAccountAttributesResponse = DescribeAccountAttributesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<AccountAttribute> accountAttributes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeAccountAttributesResponse.accountAttributes(accountAttributes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("accountAttributeSet", targetDepth)) {
                    accountAttributes = new ArrayList<AccountAttribute>();
                    continue;
                }

                if (context.testExpression("accountAttributeSet/item", targetDepth)) {
                    accountAttributes.add(AccountAttributeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeAccountAttributesResponse.accountAttributes(accountAttributes);
                    break;
                }
            }
        }
        return describeAccountAttributesResponse.build();
    }

    private static final DescribeAccountAttributesResponseUnmarshaller INSTANCE = new DescribeAccountAttributesResponseUnmarshaller();

    public static DescribeAccountAttributesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
