/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateFlowLogsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateFlowLogsRequestMarshaller implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {

    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {

        if (createFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateFlowLogsRequest> request = new DefaultRequest<CreateFlowLogsRequest>(createFlowLogsRequest, "EC2Client");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createFlowLogsRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createFlowLogsRequest.clientToken()));
        }

        if (createFlowLogsRequest.deliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn",
                    StringUtils.fromString(createFlowLogsRequest.deliverLogsPermissionArn()));
        }

        if (createFlowLogsRequest.logGroupName() != null) {
            request.addParameter("LogGroupName", StringUtils.fromString(createFlowLogsRequest.logGroupName()));
        }

        java.util.List<String> createFlowLogsRequestResourceIdsList = createFlowLogsRequest.resourceIds();
        if (createFlowLogsRequestResourceIdsList != null) {
            int resourceIdsListIndex = 1;

            for (String createFlowLogsRequestResourceIdsListValue : createFlowLogsRequestResourceIdsList) {
                if (createFlowLogsRequestResourceIdsListValue != null) {
                    request.addParameter("ResourceId." + resourceIdsListIndex,
                            StringUtils.fromString(createFlowLogsRequestResourceIdsListValue));
                }
                resourceIdsListIndex++;
            }
        }

        if (createFlowLogsRequest.resourceTypeString() != null) {
            request.addParameter("ResourceType", StringUtils.fromString(createFlowLogsRequest.resourceTypeString()));
        }

        if (createFlowLogsRequest.trafficTypeString() != null) {
            request.addParameter("TrafficType", StringUtils.fromString(createFlowLogsRequest.trafficTypeString()));
        }

        return request;
    }

}
