/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a static route for a VPN connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnStaticRoute implements ToCopyableBuilder<VpnStaticRoute.Builder, VpnStaticRoute> {
    private final String destinationCidrBlock;

    private final String source;

    private final String state;

    private VpnStaticRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.source = builder.source;
        this.state = builder.state;
    }

    /**
     * <p>
     * The CIDR block associated with the local subnet of the customer data center.
     * </p>
     * 
     * @return The CIDR block associated with the local subnet of the customer data center.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * Indicates how the routes were provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link VpnStaticRouteSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceString}.
     * </p>
     * 
     * @return Indicates how the routes were provided.
     * @see VpnStaticRouteSource
     */
    public VpnStaticRouteSource source() {
        return VpnStaticRouteSource.fromValue(source);
    }

    /**
     * <p>
     * Indicates how the routes were provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link VpnStaticRouteSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceString}.
     * </p>
     * 
     * @return Indicates how the routes were provided.
     * @see VpnStaticRouteSource
     */
    public String sourceString() {
        return source;
    }

    /**
     * <p>
     * The current state of the static route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the static route.
     * @see VpnState
     */
    public VpnState state() {
        return VpnState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the static route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the static route.
     * @see VpnState
     */
    public String stateString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationCidrBlock() == null) ? 0 : destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + ((sourceString() == null) ? 0 : sourceString().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnStaticRoute)) {
            return false;
        }
        VpnStaticRoute other = (VpnStaticRoute) obj;
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.sourceString() == null ^ this.sourceString() == null) {
            return false;
        }
        if (other.sourceString() != null && !other.sourceString().equals(this.sourceString())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(destinationCidrBlock()).append(",");
        }
        if (sourceString() != null) {
            sb.append("Source: ").append(sourceString()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.of(clazz.cast(destinationCidrBlock()));
        case "Source":
            return Optional.of(clazz.cast(sourceString()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpnStaticRoute> {
        /**
         * <p>
         * The CIDR block associated with the local subnet of the customer data center.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The CIDR block associated with the local subnet of the customer data center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * Indicates how the routes were provided.
         * </p>
         * 
         * @param source
         *        Indicates how the routes were provided.
         * @see VpnStaticRouteSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnStaticRouteSource
         */
        Builder source(String source);

        /**
         * <p>
         * Indicates how the routes were provided.
         * </p>
         * 
         * @param source
         *        Indicates how the routes were provided.
         * @see VpnStaticRouteSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnStaticRouteSource
         */
        Builder source(VpnStaticRouteSource source);

        /**
         * <p>
         * The current state of the static route.
         * </p>
         * 
         * @param state
         *        The current state of the static route.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the static route.
         * </p>
         * 
         * @param state
         *        The current state of the static route.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(VpnState state);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String source;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnStaticRoute model) {
            destinationCidrBlock(model.destinationCidrBlock);
            source(model.source);
            state(model.state);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(VpnStaticRouteSource source) {
            this.source(source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public VpnStaticRoute build() {
            return new VpnStaticRoute(this);
        }
    }
}
