/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a CIDR block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcCidrBlockState implements ToCopyableBuilder<VpcCidrBlockState.Builder, VpcCidrBlockState> {
    private final String state;

    private final String statusMessage;

    private VpcCidrBlockState(BuilderImpl builder) {
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The state of the CIDR block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcCidrBlockStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the CIDR block.
     * @see VpcCidrBlockStateCode
     */
    public VpcCidrBlockStateCode state() {
        return VpcCidrBlockStateCode.fromValue(state);
    }

    /**
     * <p>
     * The state of the CIDR block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcCidrBlockStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the CIDR block.
     * @see VpcCidrBlockStateCode
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * A message about the status of the CIDR block, if applicable.
     * </p>
     * 
     * @return A message about the status of the CIDR block, if applicable.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcCidrBlockState)) {
            return false;
        }
        VpcCidrBlockState other = (VpcCidrBlockState) obj;
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpcCidrBlockState> {
        /**
         * <p>
         * The state of the CIDR block.
         * </p>
         * 
         * @param state
         *        The state of the CIDR block.
         * @see VpcCidrBlockStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcCidrBlockStateCode
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the CIDR block.
         * </p>
         * 
         * @param state
         *        The state of the CIDR block.
         * @see VpcCidrBlockStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcCidrBlockStateCode
         */
        Builder state(VpcCidrBlockStateCode state);

        /**
         * <p>
         * A message about the status of the CIDR block, if applicable.
         * </p>
         * 
         * @param statusMessage
         *        A message about the status of the CIDR block, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcCidrBlockState model) {
            state(model.state);
            statusMessage(model.statusMessage);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcCidrBlockStateCode state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public VpcCidrBlockState build() {
            return new VpcCidrBlockState(this);
        }
    }
}
