/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume status operation code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusAction implements ToCopyableBuilder<VolumeStatusAction.Builder, VolumeStatusAction> {
    private final String code;

    private final String description;

    private final String eventId;

    private final String eventType;

    private VolumeStatusAction(BuilderImpl builder) {
        this.code = builder.code;
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
    }

    /**
     * <p>
     * The code identifying the operation, for example, <code>enable-volume-io</code>.
     * </p>
     * 
     * @return The code identifying the operation, for example, <code>enable-volume-io</code>.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * A description of the operation.
     * </p>
     * 
     * @return A description of the operation.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the event associated with this operation.
     * </p>
     * 
     * @return The ID of the event associated with this operation.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type associated with this operation.
     * </p>
     * 
     * @return The event type associated with this operation.
     */
    public String eventType() {
        return eventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((code() == null) ? 0 : code().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((eventId() == null) ? 0 : eventId().hashCode());
        hashCode = 31 * hashCode + ((eventType() == null) ? 0 : eventType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusAction)) {
            return false;
        }
        VolumeStatusAction other = (VolumeStatusAction) obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.eventType() == null ^ this.eventType() == null) {
            return false;
        }
        if (other.eventType() != null && !other.eventType().equals(this.eventType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (code() != null) {
            sb.append("Code: ").append(code()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (eventId() != null) {
            sb.append("EventId: ").append(eventId()).append(",");
        }
        if (eventType() != null) {
            sb.append("EventType: ").append(eventType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.of(clazz.cast(code()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "EventId":
            return Optional.of(clazz.cast(eventId()));
        case "EventType":
            return Optional.of(clazz.cast(eventType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusAction> {
        /**
         * <p>
         * The code identifying the operation, for example, <code>enable-volume-io</code>.
         * </p>
         * 
         * @param code
         *        The code identifying the operation, for example, <code>enable-volume-io</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A description of the operation.
         * </p>
         * 
         * @param description
         *        A description of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the event associated with this operation.
         * </p>
         * 
         * @param eventId
         *        The ID of the event associated with this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type associated with this operation.
         * </p>
         * 
         * @param eventType
         *        The event type associated with this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String description;

        private String eventId;

        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusAction model) {
            code(model.code);
            description(model.description);
            eventId(model.eventId);
            eventType(model.eventType);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public VolumeStatusAction build() {
            return new VolumeStatusAction(this);
        }
    }
}
