/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UnassignIpv6AddressesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UnassignIpv6AddressesResponse.Builder, UnassignIpv6AddressesResponse> {
    private final String networkInterfaceId;

    private final List<String> unassignedIpv6Addresses;

    private UnassignIpv6AddressesResponse(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.unassignedIpv6Addresses = builder.unassignedIpv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The IPv6 addresses that have been unassigned from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IPv6 addresses that have been unassigned from the network interface.
     */
    public List<String> unassignedIpv6Addresses() {
        return unassignedIpv6Addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((unassignedIpv6Addresses() == null) ? 0 : unassignedIpv6Addresses().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesResponse)) {
            return false;
        }
        UnassignIpv6AddressesResponse other = (UnassignIpv6AddressesResponse) obj;
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.unassignedIpv6Addresses() == null ^ this.unassignedIpv6Addresses() == null) {
            return false;
        }
        if (other.unassignedIpv6Addresses() != null && !other.unassignedIpv6Addresses().equals(this.unassignedIpv6Addresses())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (unassignedIpv6Addresses() != null) {
            sb.append("UnassignedIpv6Addresses: ").append(unassignedIpv6Addresses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "UnassignedIpv6Addresses":
            return Optional.of(clazz.cast(unassignedIpv6Addresses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IPv6 addresses that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Addresses
         *        The IPv6 addresses that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses);

        /**
         * <p>
         * The IPv6 addresses that have been unassigned from the network interface.
         * </p>
         * 
         * @param unassignedIpv6Addresses
         *        The IPv6 addresses that have been unassigned from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassignedIpv6Addresses(String... unassignedIpv6Addresses);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceId;

        private List<String> unassignedIpv6Addresses;

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesResponse model) {
            networkInterfaceId(model.networkInterfaceId);
            unassignedIpv6Addresses(model.unassignedIpv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getUnassignedIpv6Addresses() {
            return unassignedIpv6Addresses;
        }

        @Override
        public final Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Addresses(String... unassignedIpv6Addresses) {
            unassignedIpv6Addresses(Arrays.asList(unassignedIpv6Addresses));
            return this;
        }

        public final void setUnassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
        }

        @Override
        public UnassignIpv6AddressesResponse build() {
            return new UnassignIpv6AddressesResponse(this);
        }
    }
}
