/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total value of the new Convertible Reserved Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetReservationValue implements ToCopyableBuilder<TargetReservationValue.Builder, TargetReservationValue> {
    private final ReservationValue reservationValue;

    private final TargetConfiguration targetConfiguration;

    private TargetReservationValue(BuilderImpl builder) {
        this.reservationValue = builder.reservationValue;
        this.targetConfiguration = builder.targetConfiguration;
    }

    /**
     * <p>
     * The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the list
     * value, remaining upfront price, and additional upfront cost of the exchange.
     * </p>
     * 
     * @return The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the
     *         list value, remaining upfront price, and additional upfront cost of the exchange.
     */
    public ReservationValue reservationValue() {
        return reservationValue;
    }

    /**
     * <p>
     * The configuration of the Convertible Reserved Instances that make up the exchange.
     * </p>
     * 
     * @return The configuration of the Convertible Reserved Instances that make up the exchange.
     */
    public TargetConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservationValue() == null) ? 0 : reservationValue().hashCode());
        hashCode = 31 * hashCode + ((targetConfiguration() == null) ? 0 : targetConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetReservationValue)) {
            return false;
        }
        TargetReservationValue other = (TargetReservationValue) obj;
        if (other.reservationValue() == null ^ this.reservationValue() == null) {
            return false;
        }
        if (other.reservationValue() != null && !other.reservationValue().equals(this.reservationValue())) {
            return false;
        }
        if (other.targetConfiguration() == null ^ this.targetConfiguration() == null) {
            return false;
        }
        if (other.targetConfiguration() != null && !other.targetConfiguration().equals(this.targetConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (reservationValue() != null) {
            sb.append("ReservationValue: ").append(reservationValue()).append(",");
        }
        if (targetConfiguration() != null) {
            sb.append("TargetConfiguration: ").append(targetConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservationValue":
            return Optional.of(clazz.cast(reservationValue()));
        case "TargetConfiguration":
            return Optional.of(clazz.cast(targetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TargetReservationValue> {
        /**
         * <p>
         * The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the list
         * value, remaining upfront price, and additional upfront cost of the exchange.
         * </p>
         * 
         * @param reservationValue
         *        The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of
         *        the list value, remaining upfront price, and additional upfront cost of the exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationValue(ReservationValue reservationValue);

        /**
         * <p>
         * The configuration of the Convertible Reserved Instances that make up the exchange.
         * </p>
         * 
         * @param targetConfiguration
         *        The configuration of the Convertible Reserved Instances that make up the exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(TargetConfiguration targetConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private ReservationValue reservationValue;

        private TargetConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetReservationValue model) {
            reservationValue(model.reservationValue);
            targetConfiguration(model.targetConfiguration);
        }

        public final ReservationValue.Builder getReservationValue() {
            return reservationValue != null ? reservationValue.toBuilder() : null;
        }

        @Override
        public final Builder reservationValue(ReservationValue reservationValue) {
            this.reservationValue = reservationValue;
            return this;
        }

        public final void setReservationValue(ReservationValue.BuilderImpl reservationValue) {
            this.reservationValue = reservationValue != null ? reservationValue.build() : null;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public TargetReservationValue build() {
            return new TargetReservationValue(this);
        }
    }
}
