/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of StopInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StopInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<StopInstancesResponse.Builder, StopInstancesResponse> {
    private final List<InstanceStateChange> stoppingInstances;

    private StopInstancesResponse(BuilderImpl builder) {
        this.stoppingInstances = builder.stoppingInstances;
    }

    /**
     * <p>
     * Information about one or more stopped instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more stopped instances.
     */
    public List<InstanceStateChange> stoppingInstances() {
        return stoppingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stoppingInstances() == null) ? 0 : stoppingInstances().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesResponse)) {
            return false;
        }
        StopInstancesResponse other = (StopInstancesResponse) obj;
        if (other.stoppingInstances() == null ^ this.stoppingInstances() == null) {
            return false;
        }
        if (other.stoppingInstances() != null && !other.stoppingInstances().equals(this.stoppingInstances())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stoppingInstances() != null) {
            sb.append("StoppingInstances: ").append(stoppingInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoppingInstances":
            return Optional.of(clazz.cast(stoppingInstances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StopInstancesResponse> {
        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about one or more stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances);

        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about one or more stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(InstanceStateChange... stoppingInstances);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceStateChange> stoppingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesResponse model) {
            stoppingInstances(model.stoppingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getStoppingInstances() {
            return stoppingInstances != null ? stoppingInstances.stream().map(InstanceStateChange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copy(stoppingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(InstanceStateChange... stoppingInstances) {
            stoppingInstances(Arrays.asList(stoppingInstances));
            return this;
        }

        public final void setStoppingInstances(Collection<InstanceStateChange.BuilderImpl> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copyFromBuilder(stoppingInstances);
        }

        @Override
        public StopInstancesResponse build() {
            return new StopInstancesResponse(this);
        }
    }
}
