/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the maximum hourly price (bid) for any Spot instance launched to fulfill the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotPrice implements ToCopyableBuilder<SpotPrice.Builder, SpotPrice> {
    private final String availabilityZone;

    private final String instanceType;

    private final String productDescription;

    private final String spotPrice;

    private final Instant timestamp;

    private SpotPrice(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.spotPrice = builder.spotPrice;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The instance type. Note that T2 and HS1 instance types are not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. Note that T2 and HS1 instance types are not supported.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. Note that T2 and HS1 instance types are not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. Note that T2 and HS1 instance types are not supported.
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * A general description of the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return A general description of the AMI.
     * @see RIProductDescription
     */
    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(productDescription);
    }

    /**
     * <p>
     * A general description of the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return A general description of the AMI.
     * @see RIProductDescription
     */
    public String productDescriptionString() {
        return productDescription;
    }

    /**
     * <p>
     * The maximum price (bid) that you are willing to pay for a Spot instance.
     * </p>
     * 
     * @return The maximum price (bid) that you are willing to pay for a Spot instance.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The date and time the request was created, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time the request was created, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((instanceTypeString() == null) ? 0 : instanceTypeString().hashCode());
        hashCode = 31 * hashCode + ((productDescriptionString() == null) ? 0 : productDescriptionString().hashCode());
        hashCode = 31 * hashCode + ((spotPrice() == null) ? 0 : spotPrice().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPrice)) {
            return false;
        }
        SpotPrice other = (SpotPrice) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.instanceTypeString() == null ^ this.instanceTypeString() == null) {
            return false;
        }
        if (other.instanceTypeString() != null && !other.instanceTypeString().equals(this.instanceTypeString())) {
            return false;
        }
        if (other.productDescriptionString() == null ^ this.productDescriptionString() == null) {
            return false;
        }
        if (other.productDescriptionString() != null && !other.productDescriptionString().equals(this.productDescriptionString())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (instanceTypeString() != null) {
            sb.append("InstanceType: ").append(instanceTypeString()).append(",");
        }
        if (productDescriptionString() != null) {
            sb.append("ProductDescription: ").append(productDescriptionString()).append(",");
        }
        if (spotPrice() != null) {
            sb.append("SpotPrice: ").append(spotPrice()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "ProductDescription":
            return Optional.of(clazz.cast(productDescriptionString()));
        case "SpotPrice":
            return Optional.of(clazz.cast(spotPrice()));
        case "Timestamp":
            return Optional.of(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SpotPrice> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The instance type. Note that T2 and HS1 instance types are not supported.
         * </p>
         * 
         * @param instanceType
         *        The instance type. Note that T2 and HS1 instance types are not supported.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. Note that T2 and HS1 instance types are not supported.
         * </p>
         * 
         * @param instanceType
         *        The instance type. Note that T2 and HS1 instance types are not supported.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * A general description of the AMI.
         * </p>
         * 
         * @param productDescription
         *        A general description of the AMI.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * A general description of the AMI.
         * </p>
         * 
         * @param productDescription
         *        A general description of the AMI.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * The maximum price (bid) that you are willing to pay for a Spot instance.
         * </p>
         * 
         * @param spotPrice
         *        The maximum price (bid) that you are willing to pay for a Spot instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The date and time the request was created, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param timestamp
         *        The date and time the request was created, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String instanceType;

        private String productDescription;

        private String spotPrice;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPrice model) {
            availabilityZone(model.availabilityZone);
            instanceType(model.instanceType);
            productDescription(model.productDescription);
            spotPrice(model.spotPrice);
            timestamp(model.timestamp);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public SpotPrice build() {
            return new SpotPrice(this);
        }
    }
}
