/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a Spot fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotFleetRequestConfigData implements
        ToCopyableBuilder<SpotFleetRequestConfigData.Builder, SpotFleetRequestConfigData> {
    private final String allocationStrategy;

    private final String clientToken;

    private final String excessCapacityTerminationPolicy;

    private final Double fulfilledCapacity;

    private final String iamFleetRole;

    private final List<SpotFleetLaunchSpecification> launchSpecifications;

    private final String spotPrice;

    private final Integer targetCapacity;

    private final Boolean terminateInstancesWithExpiration;

    private final String type;

    private final Instant validFrom;

    private final Instant validUntil;

    private final Boolean replaceUnhealthyInstances;

    private SpotFleetRequestConfigData(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.iamFleetRole = builder.iamFleetRole;
        this.launchSpecifications = builder.launchSpecifications;
        this.spotPrice = builder.spotPrice;
        this.targetCapacity = builder.targetCapacity;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
    }

    /**
     * <p>
     * Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet request. The
     * default is <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyString}.
     * </p>
     * 
     * @return Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet request.
     *         The default is <code>lowestPrice</code>.
     * @see AllocationStrategy
     */
    public AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet request. The
     * default is <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyString}.
     * </p>
     * 
     * @return Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet request.
     *         The default is <code>lowestPrice</code>.
     * @see AllocationStrategy
     */
    public String allocationStrategyString() {
        return allocationStrategy;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
     * duplicate listings. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
     *         duplicate listings. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is
     * decreased below the current size of the Spot fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyString}.
     * </p>
     * 
     * @return Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
     *         request is decreased below the current size of the Spot fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is
     * decreased below the current size of the Spot fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyString}.
     * </p>
     * 
     * @return Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
     *         request is decreased below the current size of the Spot fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public String excessCapacityTerminationPolicyString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * <p>
     * The number of units fulfilled by this request compared to the set target capacity.
     * </p>
     * 
     * @return The number of units fulfilled by this request compared to the set target capacity.
     */
    public Double fulfilledCapacity() {
        return fulfilledCapacity;
    }

    /**
     * <p>
     * Grants the Spot fleet permission to terminate Spot instances on your behalf when you cancel its Spot fleet
     * request using <a>CancelSpotFleetRequests</a> or when the Spot fleet request expires, if you set
     * <code>terminateInstancesWithExpiration</code>.
     * </p>
     * 
     * @return Grants the Spot fleet permission to terminate Spot instances on your behalf when you cancel its Spot
     *         fleet request using <a>CancelSpotFleetRequests</a> or when the Spot fleet request expires, if you set
     *         <code>terminateInstancesWithExpiration</code>.
     */
    public String iamFleetRole() {
        return iamFleetRole;
    }

    /**
     * <p>
     * Information about the launch specifications for the Spot fleet request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the launch specifications for the Spot fleet request.
     */
    public List<SpotFleetLaunchSpecification> launchSpecifications() {
        return launchSpecifications;
    }

    /**
     * <p>
     * The bid price per unit hour.
     * </p>
     * 
     * @return The bid price per unit hour.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The number of units to request. You can choose to set the target capacity in terms of instances or a performance
     * characteristic that is important to your application workload, such as vCPUs, memory, or I/O.
     * </p>
     * 
     * @return The number of units to request. You can choose to set the target capacity in terms of instances or a
     *         performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O.
     */
    public Integer targetCapacity() {
        return targetCapacity;
    }

    /**
     * <p>
     * Indicates whether running Spot instances should be terminated when the Spot fleet request expires.
     * </p>
     * 
     * @return Indicates whether running Spot instances should be terminated when the Spot fleet request expires.
     */
    public Boolean terminateInstancesWithExpiration() {
        return terminateInstancesWithExpiration;
    }

    /**
     * <p>
     * The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or also
     * attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the fleet will only
     * place the required bids. It will not attempt to replenish Spot instances if capacity is diminished, nor will it
     * submit bids in alternative Spot pools if capacity is not available. When you want to <code>maintain</code> a
     * certain target capacity, fleet will place the required bids to meet this target capacity. It will also
     * automatically replenish any interrupted instances. Default: <code>maintain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or
     *         also attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the
     *         fleet will only place the required bids. It will not attempt to replenish Spot instances if capacity is
     *         diminished, nor will it submit bids in alternative Spot pools if capacity is not available. When you want
     *         to <code>maintain</code> a certain target capacity, fleet will place the required bids to meet this
     *         target capacity. It will also automatically replenish any interrupted instances. Default:
     *         <code>maintain</code>.
     * @see FleetType
     */
    public FleetType type() {
        return FleetType.fromValue(type);
    }

    /**
     * <p>
     * The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or also
     * attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the fleet will only
     * place the required bids. It will not attempt to replenish Spot instances if capacity is diminished, nor will it
     * submit bids in alternative Spot pools if capacity is not available. When you want to <code>maintain</code> a
     * certain target capacity, fleet will place the required bids to meet this target capacity. It will also
     * automatically replenish any interrupted instances. Default: <code>maintain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or
     *         also attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the
     *         fleet will only place the required bids. It will not attempt to replenish Spot instances if capacity is
     *         diminished, nor will it submit bids in alternative Spot pools if capacity is not available. When you want
     *         to <code>maintain</code> a certain target capacity, fleet will place the required bids to meet this
     *         target capacity. It will also automatically replenish any interrupted instances. Default:
     *         <code>maintain</code>.
     * @see FleetType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The start date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request
     * immediately.
     * </p>
     * 
     * @return The start date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
     *         request immediately.
     */
    public Instant validFrom() {
        return validFrom;
    }

    /**
     * <p>
     * The end date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot instance requests are
     * placed or enabled to fulfill the request.
     * </p>
     * 
     * @return The end date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot instance
     *         requests are placed or enabled to fulfill the request.
     */
    public Instant validUntil() {
        return validUntil;
    }

    /**
     * <p>
     * Indicates whether Spot fleet should replace unhealthy instances.
     * </p>
     * 
     * @return Indicates whether Spot fleet should replace unhealthy instances.
     */
    public Boolean replaceUnhealthyInstances() {
        return replaceUnhealthyInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((allocationStrategyString() == null) ? 0 : allocationStrategyString().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode
                + ((excessCapacityTerminationPolicyString() == null) ? 0 : excessCapacityTerminationPolicyString().hashCode());
        hashCode = 31 * hashCode + ((fulfilledCapacity() == null) ? 0 : fulfilledCapacity().hashCode());
        hashCode = 31 * hashCode + ((iamFleetRole() == null) ? 0 : iamFleetRole().hashCode());
        hashCode = 31 * hashCode + ((launchSpecifications() == null) ? 0 : launchSpecifications().hashCode());
        hashCode = 31 * hashCode + ((spotPrice() == null) ? 0 : spotPrice().hashCode());
        hashCode = 31 * hashCode + ((targetCapacity() == null) ? 0 : targetCapacity().hashCode());
        hashCode = 31 * hashCode
                + ((terminateInstancesWithExpiration() == null) ? 0 : terminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((validFrom() == null) ? 0 : validFrom().hashCode());
        hashCode = 31 * hashCode + ((validUntil() == null) ? 0 : validUntil().hashCode());
        hashCode = 31 * hashCode + ((replaceUnhealthyInstances() == null) ? 0 : replaceUnhealthyInstances().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData) obj;
        if (other.allocationStrategyString() == null ^ this.allocationStrategyString() == null) {
            return false;
        }
        if (other.allocationStrategyString() != null && !other.allocationStrategyString().equals(this.allocationStrategyString())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.excessCapacityTerminationPolicyString() == null ^ this.excessCapacityTerminationPolicyString() == null) {
            return false;
        }
        if (other.excessCapacityTerminationPolicyString() != null
                && !other.excessCapacityTerminationPolicyString().equals(this.excessCapacityTerminationPolicyString())) {
            return false;
        }
        if (other.fulfilledCapacity() == null ^ this.fulfilledCapacity() == null) {
            return false;
        }
        if (other.fulfilledCapacity() != null && !other.fulfilledCapacity().equals(this.fulfilledCapacity())) {
            return false;
        }
        if (other.iamFleetRole() == null ^ this.iamFleetRole() == null) {
            return false;
        }
        if (other.iamFleetRole() != null && !other.iamFleetRole().equals(this.iamFleetRole())) {
            return false;
        }
        if (other.launchSpecifications() == null ^ this.launchSpecifications() == null) {
            return false;
        }
        if (other.launchSpecifications() != null && !other.launchSpecifications().equals(this.launchSpecifications())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.targetCapacity() == null ^ this.targetCapacity() == null) {
            return false;
        }
        if (other.targetCapacity() != null && !other.targetCapacity().equals(this.targetCapacity())) {
            return false;
        }
        if (other.terminateInstancesWithExpiration() == null ^ this.terminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.terminateInstancesWithExpiration() != null
                && !other.terminateInstancesWithExpiration().equals(this.terminateInstancesWithExpiration())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.validFrom() == null ^ this.validFrom() == null) {
            return false;
        }
        if (other.validFrom() != null && !other.validFrom().equals(this.validFrom())) {
            return false;
        }
        if (other.validUntil() == null ^ this.validUntil() == null) {
            return false;
        }
        if (other.validUntil() != null && !other.validUntil().equals(this.validUntil())) {
            return false;
        }
        if (other.replaceUnhealthyInstances() == null ^ this.replaceUnhealthyInstances() == null) {
            return false;
        }
        if (other.replaceUnhealthyInstances() != null
                && !other.replaceUnhealthyInstances().equals(this.replaceUnhealthyInstances())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (allocationStrategyString() != null) {
            sb.append("AllocationStrategy: ").append(allocationStrategyString()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (excessCapacityTerminationPolicyString() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(excessCapacityTerminationPolicyString()).append(",");
        }
        if (fulfilledCapacity() != null) {
            sb.append("FulfilledCapacity: ").append(fulfilledCapacity()).append(",");
        }
        if (iamFleetRole() != null) {
            sb.append("IamFleetRole: ").append(iamFleetRole()).append(",");
        }
        if (launchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(launchSpecifications()).append(",");
        }
        if (spotPrice() != null) {
            sb.append("SpotPrice: ").append(spotPrice()).append(",");
        }
        if (targetCapacity() != null) {
            sb.append("TargetCapacity: ").append(targetCapacity()).append(",");
        }
        if (terminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: ").append(terminateInstancesWithExpiration()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (validFrom() != null) {
            sb.append("ValidFrom: ").append(validFrom()).append(",");
        }
        if (validUntil() != null) {
            sb.append("ValidUntil: ").append(validUntil()).append(",");
        }
        if (replaceUnhealthyInstances() != null) {
            sb.append("ReplaceUnhealthyInstances: ").append(replaceUnhealthyInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationStrategy":
            return Optional.of(clazz.cast(allocationStrategyString()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "ExcessCapacityTerminationPolicy":
            return Optional.of(clazz.cast(excessCapacityTerminationPolicyString()));
        case "FulfilledCapacity":
            return Optional.of(clazz.cast(fulfilledCapacity()));
        case "IamFleetRole":
            return Optional.of(clazz.cast(iamFleetRole()));
        case "LaunchSpecifications":
            return Optional.of(clazz.cast(launchSpecifications()));
        case "SpotPrice":
            return Optional.of(clazz.cast(spotPrice()));
        case "TargetCapacity":
            return Optional.of(clazz.cast(targetCapacity()));
        case "TerminateInstancesWithExpiration":
            return Optional.of(clazz.cast(terminateInstancesWithExpiration()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "ValidFrom":
            return Optional.of(clazz.cast(validFrom()));
        case "ValidUntil":
            return Optional.of(clazz.cast(validUntil()));
        case "ReplaceUnhealthyInstances":
            return Optional.of(clazz.cast(replaceUnhealthyInstances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SpotFleetRequestConfigData> {
        /**
         * <p>
         * Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet request. The
         * default is <code>lowestPrice</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet
         *        request. The default is <code>lowestPrice</code>.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet request. The
         * default is <code>lowestPrice</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet
         *        request. The default is <code>lowestPrice</code>.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(AllocationStrategy allocationStrategy);

        /**
         * <p>
         * A unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
         * duplicate listings. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps
         *        avoid duplicate listings. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         * request is decreased below the current size of the Spot fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         *        request is decreased below the current size of the Spot fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         * request is decreased below the current size of the Spot fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         *        request is decreased below the current size of the Spot fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The number of units fulfilled by this request compared to the set target capacity.
         * </p>
         * 
         * @param fulfilledCapacity
         *        The number of units fulfilled by this request compared to the set target capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfilledCapacity(Double fulfilledCapacity);

        /**
         * <p>
         * Grants the Spot fleet permission to terminate Spot instances on your behalf when you cancel its Spot fleet
         * request using <a>CancelSpotFleetRequests</a> or when the Spot fleet request expires, if you set
         * <code>terminateInstancesWithExpiration</code>.
         * </p>
         * 
         * @param iamFleetRole
         *        Grants the Spot fleet permission to terminate Spot instances on your behalf when you cancel its Spot
         *        fleet request using <a>CancelSpotFleetRequests</a> or when the Spot fleet request expires, if you set
         *        <code>terminateInstancesWithExpiration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamFleetRole(String iamFleetRole);

        /**
         * <p>
         * Information about the launch specifications for the Spot fleet request.
         * </p>
         * 
         * @param launchSpecifications
         *        Information about the launch specifications for the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications);

        /**
         * <p>
         * Information about the launch specifications for the Spot fleet request.
         * </p>
         * 
         * @param launchSpecifications
         *        Information about the launch specifications for the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecifications(SpotFleetLaunchSpecification... launchSpecifications);

        /**
         * <p>
         * The bid price per unit hour.
         * </p>
         * 
         * @param spotPrice
         *        The bid price per unit hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The number of units to request. You can choose to set the target capacity in terms of instances or a
         * performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O.
         * </p>
         * 
         * @param targetCapacity
         *        The number of units to request. You can choose to set the target capacity in terms of instances or a
         *        performance characteristic that is important to your application workload, such as vCPUs, memory, or
         *        I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacity(Integer targetCapacity);

        /**
         * <p>
         * Indicates whether running Spot instances should be terminated when the Spot fleet request expires.
         * </p>
         * 
         * @param terminateInstancesWithExpiration
         *        Indicates whether running Spot instances should be terminated when the Spot fleet request expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration);

        /**
         * <p>
         * The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or also
         * attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the fleet will
         * only place the required bids. It will not attempt to replenish Spot instances if capacity is diminished, nor
         * will it submit bids in alternative Spot pools if capacity is not available. When you want to
         * <code>maintain</code> a certain target capacity, fleet will place the required bids to meet this target
         * capacity. It will also automatically replenish any interrupted instances. Default: <code>maintain</code>.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or
         *        also attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the
         *        fleet will only place the required bids. It will not attempt to replenish Spot instances if capacity
         *        is diminished, nor will it submit bids in alternative Spot pools if capacity is not available. When
         *        you want to <code>maintain</code> a certain target capacity, fleet will place the required bids to
         *        meet this target capacity. It will also automatically replenish any interrupted instances. Default:
         *        <code>maintain</code>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or also
         * attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the fleet will
         * only place the required bids. It will not attempt to replenish Spot instances if capacity is diminished, nor
         * will it submit bids in alternative Spot pools if capacity is not available. When you want to
         * <code>maintain</code> a certain target capacity, fleet will place the required bids to meet this target
         * capacity. It will also automatically replenish any interrupted instances. Default: <code>maintain</code>.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or
         *        also attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the
         *        fleet will only place the required bids. It will not attempt to replenish Spot instances if capacity
         *        is diminished, nor will it submit bids in alternative Spot pools if capacity is not available. When
         *        you want to <code>maintain</code> a certain target capacity, fleet will place the required bids to
         *        meet this target capacity. It will also automatically replenish any interrupted instances. Default:
         *        <code>maintain</code>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(FleetType type);

        /**
         * <p>
         * The start date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
         * request immediately.
         * </p>
         * 
         * @param validFrom
         *        The start date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling
         *        the request immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFrom(Instant validFrom);

        /**
         * <p>
         * The end date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot instance requests
         * are placed or enabled to fulfill the request.
         * </p>
         * 
         * @param validUntil
         *        The end date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot instance
         *        requests are placed or enabled to fulfill the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * Indicates whether Spot fleet should replace unhealthy instances.
         * </p>
         * 
         * @param replaceUnhealthyInstances
         *        Indicates whether Spot fleet should replace unhealthy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances);
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private String clientToken;

        private String excessCapacityTerminationPolicy;

        private Double fulfilledCapacity;

        private String iamFleetRole;

        private List<SpotFleetLaunchSpecification> launchSpecifications;

        private String spotPrice;

        private Integer targetCapacity;

        private Boolean terminateInstancesWithExpiration;

        private String type;

        private Instant validFrom;

        private Instant validUntil;

        private Boolean replaceUnhealthyInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfigData model) {
            allocationStrategy(model.allocationStrategy);
            clientToken(model.clientToken);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            fulfilledCapacity(model.fulfilledCapacity);
            iamFleetRole(model.iamFleetRole);
            launchSpecifications(model.launchSpecifications);
            spotPrice(model.spotPrice);
            targetCapacity(model.targetCapacity);
            terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            type(model.type);
            validFrom(model.validFrom);
            validUntil(model.validUntil);
            replaceUnhealthyInstances(model.replaceUnhealthyInstances);
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final String getIamFleetRole() {
            return iamFleetRole;
        }

        @Override
        public final Builder iamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
            return this;
        }

        public final void setIamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
        }

        public final Collection<SpotFleetLaunchSpecification.Builder> getLaunchSpecifications() {
            return launchSpecifications != null ? launchSpecifications.stream().map(SpotFleetLaunchSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copy(launchSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(SpotFleetLaunchSpecification... launchSpecifications) {
            launchSpecifications(Arrays.asList(launchSpecifications));
            return this;
        }

        public final void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification.BuilderImpl> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copyFromBuilder(launchSpecifications);
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final Integer getTargetCapacity() {
            return targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        @Override
        public SpotFleetRequestConfigData build() {
            return new SpotFleetRequestConfigData(this);
        }
    }
}
