/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for one or more Spot instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotFleetLaunchSpecification implements
        ToCopyableBuilder<SpotFleetLaunchSpecification.Builder, SpotFleetLaunchSpecification> {
    private final List<GroupIdentifier> securityGroups;

    private final String addressingType;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final Boolean ebsOptimized;

    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String imageId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final SpotFleetMonitoring monitoring;

    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;

    private final SpotPlacement placement;

    private final String ramdiskId;

    private final String spotPrice;

    private final String subnetId;

    private final String userData;

    private final Double weightedCapacity;

    private SpotFleetLaunchSpecification(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.spotPrice = builder.spotPrice;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.weightedCapacity = builder.weightedCapacity;
    }

    /**
     * <p>
     * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups.
     * When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
     *         groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
     *         groups.
     */
    public List<GroupIdentifier> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public String addressingType() {
        return addressingType;
    }

    /**
     * <p>
     * One or more block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more block device mapping entries.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
     *         This optimization isn't available with all instance types. Additional usage charges apply when using an
     *         EBS Optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type. Note that T2 and HS1 instance types are not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. Note that T2 and HS1 instance types are not supported.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. Note that T2 and HS1 instance types are not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. Note that T2 and HS1 instance types are not supported.
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Enable or disable monitoring for the instances.
     * </p>
     * 
     * @return Enable or disable monitoring for the instances.
     */
    public SpotFleetMonitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
     * group IDs using the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
     *         security group IDs using the network interface.
     */
    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The placement information.
     * </p>
     * 
     * @return The placement information.
     */
    public SpotPlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The bid price per unit hour for the specified instance type. If this value is not specified, the default is the
     * Spot bid price specified for the fleet. To determine the bid price per unit hour, divide the Spot bid price by
     * the value of <code>WeightedCapacity</code>.
     * </p>
     * 
     * @return The bid price per unit hour for the specified instance type. If this value is not specified, the default
     *         is the Spot bid price specified for the fleet. To determine the bid price per unit hour, divide the Spot
     *         bid price by the value of <code>WeightedCapacity</code>.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instances. To specify multiple subnets, separate them using commas;
     * for example, "subnet-a61dafcf, subnet-65ea5f08".
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instances. To specify multiple subnets, separate them using
     *         commas; for example, "subnet-a61dafcf, subnet-65ea5f08".
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The user data to make available to the instances. If you are using an AWS SDK or command line tool,
     * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     * Base64-encoded text.
     * </p>
     * 
     * @return The user data to make available to the instances. If you are using an AWS SDK or command line tool,
     *         Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     *         Base64-encoded text.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The number of units provided by the specified instance type. These are the same units that you chose to set the
     * target capacity in terms (instances or a performance characteristic such as vCPUs, memory, or I/O).
     * </p>
     * <p>
     * If the target capacity divided by this value is not a whole number, we round the number of instances to the next
     * whole number. If this value is not specified, the default is 1.
     * </p>
     * 
     * @return The number of units provided by the specified instance type. These are the same units that you chose to
     *         set the target capacity in terms (instances or a performance characteristic such as vCPUs, memory, or
     *         I/O).</p>
     *         <p>
     *         If the target capacity divided by this value is not a whole number, we round the number of instances to
     *         the next whole number. If this value is not specified, the default is 1.
     */
    public Double weightedCapacity() {
        return weightedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        hashCode = 31 * hashCode + ((addressingType() == null) ? 0 : addressingType().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((iamInstanceProfile() == null) ? 0 : iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((instanceTypeString() == null) ? 0 : instanceTypeString().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        hashCode = 31 * hashCode + ((monitoring() == null) ? 0 : monitoring().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaces() == null) ? 0 : networkInterfaces().hashCode());
        hashCode = 31 * hashCode + ((placement() == null) ? 0 : placement().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((spotPrice() == null) ? 0 : spotPrice().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        hashCode = 31 * hashCode + ((weightedCapacity() == null) ? 0 : weightedCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetLaunchSpecification)) {
            return false;
        }
        SpotFleetLaunchSpecification other = (SpotFleetLaunchSpecification) obj;
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.addressingType() == null ^ this.addressingType() == null) {
            return false;
        }
        if (other.addressingType() != null && !other.addressingType().equals(this.addressingType())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceTypeString() == null ^ this.instanceTypeString() == null) {
            return false;
        }
        if (other.instanceTypeString() != null && !other.instanceTypeString().equals(this.instanceTypeString())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.weightedCapacity() == null ^ this.weightedCapacity() == null) {
            return false;
        }
        if (other.weightedCapacity() != null && !other.weightedCapacity().equals(this.weightedCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        if (addressingType() != null) {
            sb.append("AddressingType: ").append(addressingType()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (instanceTypeString() != null) {
            sb.append("InstanceType: ").append(instanceTypeString()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (monitoring() != null) {
            sb.append("Monitoring: ").append(monitoring()).append(",");
        }
        if (networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(networkInterfaces()).append(",");
        }
        if (placement() != null) {
            sb.append("Placement: ").append(placement()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (spotPrice() != null) {
            sb.append("SpotPrice: ").append(spotPrice()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (weightedCapacity() != null) {
            sb.append("WeightedCapacity: ").append(weightedCapacity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroups":
            return Optional.of(clazz.cast(securityGroups()));
        case "AddressingType":
            return Optional.of(clazz.cast(addressingType()));
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "EbsOptimized":
            return Optional.of(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.of(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "KernelId":
            return Optional.of(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.of(clazz.cast(monitoring()));
        case "NetworkInterfaces":
            return Optional.of(clazz.cast(networkInterfaces()));
        case "Placement":
            return Optional.of(clazz.cast(placement()));
        case "RamdiskId":
            return Optional.of(clazz.cast(ramdiskId()));
        case "SpotPrice":
            return Optional.of(clazz.cast(spotPrice()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "UserData":
            return Optional.of(clazz.cast(userData()));
        case "WeightedCapacity":
            return Optional.of(clazz.cast(weightedCapacity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SpotFleetLaunchSpecification> {
        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<GroupIdentifier> securityGroups);

        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(GroupIdentifier... securityGroups);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param addressingType
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressingType(String addressingType);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS Optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type. Note that T2 and HS1 instance types are not supported.
         * </p>
         * 
         * @param instanceType
         *        The instance type. Note that T2 and HS1 instance types are not supported.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. Note that T2 and HS1 instance types are not supported.
         * </p>
         * 
         * @param instanceType
         *        The instance type. Note that T2 and HS1 instance types are not supported.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * 
         * @param monitoring
         *        Enable or disable monitoring for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(SpotFleetMonitoring monitoring);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * The placement information.
         * </p>
         * 
         * @param placement
         *        The placement information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(SpotPlacement placement);

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The bid price per unit hour for the specified instance type. If this value is not specified, the default is
         * the Spot bid price specified for the fleet. To determine the bid price per unit hour, divide the Spot bid
         * price by the value of <code>WeightedCapacity</code>.
         * </p>
         * 
         * @param spotPrice
         *        The bid price per unit hour for the specified instance type. If this value is not specified, the
         *        default is the Spot bid price specified for the fleet. To determine the bid price per unit hour,
         *        divide the Spot bid price by the value of <code>WeightedCapacity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The ID of the subnet in which to launch the instances. To specify multiple subnets, separate them using
         * commas; for example, "subnet-a61dafcf, subnet-65ea5f08".
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instances. To specify multiple subnets, separate them
         *        using commas; for example, "subnet-a61dafcf, subnet-65ea5f08".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The user data to make available to the instances. If you are using an AWS SDK or command line tool,
         * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
         * Base64-encoded text.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instances. If you are using an AWS SDK or command line tool,
         *        Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must
         *        provide Base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The number of units provided by the specified instance type. These are the same units that you chose to set
         * the target capacity in terms (instances or a performance characteristic such as vCPUs, memory, or I/O).
         * </p>
         * <p>
         * If the target capacity divided by this value is not a whole number, we round the number of instances to the
         * next whole number. If this value is not specified, the default is 1.
         * </p>
         * 
         * @param weightedCapacity
         *        The number of units provided by the specified instance type. These are the same units that you chose
         *        to set the target capacity in terms (instances or a performance characteristic such as vCPUs, memory,
         *        or I/O).</p>
         *        <p>
         *        If the target capacity divided by this value is not a whole number, we round the number of instances
         *        to the next whole number. If this value is not specified, the default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(Double weightedCapacity);
    }

    static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> securityGroups;

        private String addressingType;

        private List<BlockDeviceMapping> blockDeviceMappings;

        private Boolean ebsOptimized;

        private IamInstanceProfileSpecification iamInstanceProfile;

        private String imageId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private SpotFleetMonitoring monitoring;

        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;

        private SpotPlacement placement;

        private String ramdiskId;

        private String spotPrice;

        private String subnetId;

        private String userData;

        private Double weightedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetLaunchSpecification model) {
            securityGroups(model.securityGroups);
            addressingType(model.addressingType);
            blockDeviceMappings(model.blockDeviceMappings);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            monitoring(model.monitoring);
            networkInterfaces(model.networkInterfaces);
            placement(model.placement);
            ramdiskId(model.ramdiskId);
            spotPrice(model.spotPrice);
            subnetId(model.subnetId);
            userData(model.userData);
            weightedCapacity(model.weightedCapacity);
        }

        public final Collection<GroupIdentifier.Builder> getSecurityGroups() {
            return securityGroups != null ? securityGroups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        public final String getAddressingType() {
            return addressingType;
        }

        @Override
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final SpotFleetMonitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(SpotFleetMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(SpotFleetMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final Collection<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            return networkInterfaces != null ? networkInterfaces.stream().map(InstanceNetworkInterfaceSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        public final SpotPlacement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(SpotPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Double getWeightedCapacity() {
            return weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public SpotFleetLaunchSpecification build() {
            return new SpotFleetLaunchSpecification(this);
        }
    }
}
