/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data feed for a Spot instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotDatafeedSubscription implements ToCopyableBuilder<SpotDatafeedSubscription.Builder, SpotDatafeedSubscription> {
    private final String bucket;

    private final SpotInstanceStateFault fault;

    private final String ownerId;

    private final String prefix;

    private final String state;

    private SpotDatafeedSubscription(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.fault = builder.fault;
        this.ownerId = builder.ownerId;
        this.prefix = builder.prefix;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the Spot instance data feed is located.
     * </p>
     * 
     * @return The Amazon S3 bucket where the Spot instance data feed is located.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The fault codes for the Spot instance request, if any.
     * </p>
     * 
     * @return The fault codes for the Spot instance request, if any.
     */
    public SpotInstanceStateFault fault() {
        return fault;
    }

    /**
     * <p>
     * The AWS account ID of the account.
     * </p>
     * 
     * @return The AWS account ID of the account.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The prefix that is prepended to data feed files.
     * </p>
     * 
     * @return The prefix that is prepended to data feed files.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The state of the Spot instance data feed subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatafeedSubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the Spot instance data feed subscription.
     * @see DatafeedSubscriptionState
     */
    public DatafeedSubscriptionState state() {
        return DatafeedSubscriptionState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Spot instance data feed subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatafeedSubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the Spot instance data feed subscription.
     * @see DatafeedSubscriptionState
     */
    public String stateString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((fault() == null) ? 0 : fault().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotDatafeedSubscription)) {
            return false;
        }
        SpotDatafeedSubscription other = (SpotDatafeedSubscription) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.fault() == null ^ this.fault() == null) {
            return false;
        }
        if (other.fault() != null && !other.fault().equals(this.fault())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (fault() != null) {
            sb.append("Fault: ").append(fault()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Fault":
            return Optional.of(clazz.cast(fault()));
        case "OwnerId":
            return Optional.of(clazz.cast(ownerId()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SpotDatafeedSubscription> {
        /**
         * <p>
         * The Amazon S3 bucket where the Spot instance data feed is located.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket where the Spot instance data feed is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The fault codes for the Spot instance request, if any.
         * </p>
         * 
         * @param fault
         *        The fault codes for the Spot instance request, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fault(SpotInstanceStateFault fault);

        /**
         * <p>
         * The AWS account ID of the account.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The prefix that is prepended to data feed files.
         * </p>
         * 
         * @param prefix
         *        The prefix that is prepended to data feed files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The state of the Spot instance data feed subscription.
         * </p>
         * 
         * @param state
         *        The state of the Spot instance data feed subscription.
         * @see DatafeedSubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatafeedSubscriptionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Spot instance data feed subscription.
         * </p>
         * 
         * @param state
         *        The state of the Spot instance data feed subscription.
         * @see DatafeedSubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatafeedSubscriptionState
         */
        Builder state(DatafeedSubscriptionState state);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private SpotInstanceStateFault fault;

        private String ownerId;

        private String prefix;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotDatafeedSubscription model) {
            bucket(model.bucket);
            fault(model.fault);
            ownerId(model.ownerId);
            prefix(model.prefix);
            state(model.state);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final SpotInstanceStateFault.Builder getFault() {
            return fault != null ? fault.toBuilder() : null;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final void setFault(SpotInstanceStateFault.BuilderImpl fault) {
            this.fault = fault != null ? fault.build() : null;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DatafeedSubscriptionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public SpotDatafeedSubscription build() {
            return new SpotDatafeedSubscription(this);
        }
    }
}
