/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total value of the Convertible Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstanceReservationValue implements
        ToCopyableBuilder<ReservedInstanceReservationValue.Builder, ReservedInstanceReservationValue> {
    private final ReservationValue reservationValue;

    private final String reservedInstanceId;

    private ReservedInstanceReservationValue(BuilderImpl builder) {
        this.reservationValue = builder.reservationValue;
        this.reservedInstanceId = builder.reservedInstanceId;
    }

    /**
     * <p>
     * The total value of the Convertible Reserved Instance that you are exchanging.
     * </p>
     * 
     * @return The total value of the Convertible Reserved Instance that you are exchanging.
     */
    public ReservationValue reservationValue() {
        return reservationValue;
    }

    /**
     * <p>
     * The ID of the Convertible Reserved Instance that you are exchanging.
     * </p>
     * 
     * @return The ID of the Convertible Reserved Instance that you are exchanging.
     */
    public String reservedInstanceId() {
        return reservedInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservationValue() == null) ? 0 : reservationValue().hashCode());
        hashCode = 31 * hashCode + ((reservedInstanceId() == null) ? 0 : reservedInstanceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceReservationValue)) {
            return false;
        }
        ReservedInstanceReservationValue other = (ReservedInstanceReservationValue) obj;
        if (other.reservationValue() == null ^ this.reservationValue() == null) {
            return false;
        }
        if (other.reservationValue() != null && !other.reservationValue().equals(this.reservationValue())) {
            return false;
        }
        if (other.reservedInstanceId() == null ^ this.reservedInstanceId() == null) {
            return false;
        }
        if (other.reservedInstanceId() != null && !other.reservedInstanceId().equals(this.reservedInstanceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (reservationValue() != null) {
            sb.append("ReservationValue: ").append(reservationValue()).append(",");
        }
        if (reservedInstanceId() != null) {
            sb.append("ReservedInstanceId: ").append(reservedInstanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservationValue":
            return Optional.of(clazz.cast(reservationValue()));
        case "ReservedInstanceId":
            return Optional.of(clazz.cast(reservedInstanceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstanceReservationValue> {
        /**
         * <p>
         * The total value of the Convertible Reserved Instance that you are exchanging.
         * </p>
         * 
         * @param reservationValue
         *        The total value of the Convertible Reserved Instance that you are exchanging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationValue(ReservationValue reservationValue);

        /**
         * <p>
         * The ID of the Convertible Reserved Instance that you are exchanging.
         * </p>
         * 
         * @param reservedInstanceId
         *        The ID of the Convertible Reserved Instance that you are exchanging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceId(String reservedInstanceId);
    }

    static final class BuilderImpl implements Builder {
        private ReservationValue reservationValue;

        private String reservedInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceReservationValue model) {
            reservationValue(model.reservationValue);
            reservedInstanceId(model.reservedInstanceId);
        }

        public final ReservationValue.Builder getReservationValue() {
            return reservationValue != null ? reservationValue.toBuilder() : null;
        }

        @Override
        public final Builder reservationValue(ReservationValue reservationValue) {
            this.reservationValue = reservationValue;
            return this;
        }

        public final void setReservationValue(ReservationValue.BuilderImpl reservationValue) {
            this.reservationValue = reservationValue != null ? reservationValue.build() : null;
        }

        public final String getReservedInstanceId() {
            return reservedInstanceId;
        }

        @Override
        public final Builder reservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public final void setReservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
        }

        @Override
        public ReservedInstanceReservationValue build() {
            return new ReservedInstanceReservationValue(this);
        }
    }
}
