/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ReplaceRoute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReplaceRouteRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReplaceRouteRequest.Builder, ReplaceRouteRequest> {
    private final String destinationCidrBlock;

    private final String destinationIpv6CidrBlock;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final String natGatewayId;

    private final String networkInterfaceId;

    private final String routeTableId;

    private final String vpcPeeringConnectionId;

    private ReplaceRouteRequest(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.routeTableId = builder.routeTableId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The IPv4 CIDR address block used for the destination match. The value you provide must match the CIDR of an
     * existing route in the table.
     * </p>
     * 
     * @return The IPv4 CIDR address block used for the destination match. The value you provide must match the CIDR of
     *         an existing route in the table.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR address block used for the destination match. The value you provide must match the CIDR of an
     * existing route in the table.
     * </p>
     * 
     * @return The IPv6 CIDR address block used for the destination match. The value you provide must match the CIDR of
     *         an existing route in the table.
     */
    public String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * [IPv6 traffic only] The ID of an egress-only Internet gateway.
     * </p>
     * 
     * @return [IPv6 traffic only] The ID of an egress-only Internet gateway.
     */
    public String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of an Internet gateway or virtual private gateway.
     * </p>
     * 
     * @return The ID of an Internet gateway or virtual private gateway.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of a NAT instance in your VPC.
     * </p>
     * 
     * @return The ID of a NAT instance in your VPC.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * [IPv4 traffic only] The ID of a NAT gateway.
     * </p>
     * 
     * @return [IPv4 traffic only] The ID of a NAT gateway.
     */
    public String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of a network interface.
     * </p>
     * 
     * @return The ID of a network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The ID of a VPC peering connection.
     * </p>
     * 
     * @return The ID of a VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationCidrBlock() == null) ? 0 : destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + ((destinationIpv6CidrBlock() == null) ? 0 : destinationIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + ((egressOnlyInternetGatewayId() == null) ? 0 : egressOnlyInternetGatewayId().hashCode());
        hashCode = 31 * hashCode + ((gatewayId() == null) ? 0 : gatewayId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((natGatewayId() == null) ? 0 : natGatewayId().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((routeTableId() == null) ? 0 : routeTableId().hashCode());
        hashCode = 31 * hashCode + ((vpcPeeringConnectionId() == null) ? 0 : vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRouteRequest)) {
            return false;
        }
        ReplaceRouteRequest other = (ReplaceRouteRequest) obj;
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.destinationIpv6CidrBlock() == null ^ this.destinationIpv6CidrBlock() == null) {
            return false;
        }
        if (other.destinationIpv6CidrBlock() != null && !other.destinationIpv6CidrBlock().equals(this.destinationIpv6CidrBlock())) {
            return false;
        }
        if (other.egressOnlyInternetGatewayId() == null ^ this.egressOnlyInternetGatewayId() == null) {
            return false;
        }
        if (other.egressOnlyInternetGatewayId() != null
                && !other.egressOnlyInternetGatewayId().equals(this.egressOnlyInternetGatewayId())) {
            return false;
        }
        if (other.gatewayId() == null ^ this.gatewayId() == null) {
            return false;
        }
        if (other.gatewayId() != null && !other.gatewayId().equals(this.gatewayId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.natGatewayId() == null ^ this.natGatewayId() == null) {
            return false;
        }
        if (other.natGatewayId() != null && !other.natGatewayId().equals(this.natGatewayId())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.routeTableId() == null ^ this.routeTableId() == null) {
            return false;
        }
        if (other.routeTableId() != null && !other.routeTableId().equals(this.routeTableId())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionId() != null && !other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(destinationCidrBlock()).append(",");
        }
        if (destinationIpv6CidrBlock() != null) {
            sb.append("DestinationIpv6CidrBlock: ").append(destinationIpv6CidrBlock()).append(",");
        }
        if (egressOnlyInternetGatewayId() != null) {
            sb.append("EgressOnlyInternetGatewayId: ").append(egressOnlyInternetGatewayId()).append(",");
        }
        if (gatewayId() != null) {
            sb.append("GatewayId: ").append(gatewayId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (natGatewayId() != null) {
            sb.append("NatGatewayId: ").append(natGatewayId()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (routeTableId() != null) {
            sb.append("RouteTableId: ").append(routeTableId()).append(",");
        }
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.of(clazz.cast(destinationCidrBlock()));
        case "DestinationIpv6CidrBlock":
            return Optional.of(clazz.cast(destinationIpv6CidrBlock()));
        case "EgressOnlyInternetGatewayId":
            return Optional.of(clazz.cast(egressOnlyInternetGatewayId()));
        case "GatewayId":
            return Optional.of(clazz.cast(gatewayId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "NatGatewayId":
            return Optional.of(clazz.cast(natGatewayId()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "RouteTableId":
            return Optional.of(clazz.cast(routeTableId()));
        case "VpcPeeringConnectionId":
            return Optional.of(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReplaceRouteRequest> {
        /**
         * <p>
         * The IPv4 CIDR address block used for the destination match. The value you provide must match the CIDR of an
         * existing route in the table.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 CIDR address block used for the destination match. The value you provide must match the CIDR
         *        of an existing route in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The IPv6 CIDR address block used for the destination match. The value you provide must match the CIDR of an
         * existing route in the table.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        The IPv6 CIDR address block used for the destination match. The value you provide must match the CIDR
         *        of an existing route in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * [IPv6 traffic only] The ID of an egress-only Internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        [IPv6 traffic only] The ID of an egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of an Internet gateway or virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of an Internet gateway or virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of a NAT instance in your VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of a NAT instance in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * [IPv4 traffic only] The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        [IPv4 traffic only] The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of a network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The ID of a VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of a VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String destinationIpv6CidrBlock;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private String natGatewayId;

        private String networkInterfaceId;

        private String routeTableId;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRouteRequest model) {
            destinationCidrBlock(model.destinationCidrBlock);
            destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            gatewayId(model.gatewayId);
            instanceId(model.instanceId);
            natGatewayId(model.natGatewayId);
            networkInterfaceId(model.networkInterfaceId);
            routeTableId(model.routeTableId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public ReplaceRouteRequest build() {
            return new ReplaceRouteRequest(this);
        }
    }
}
