/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ReplaceNetworkAclAssociation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReplaceNetworkAclAssociationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReplaceNetworkAclAssociationRequest.Builder, ReplaceNetworkAclAssociationRequest> {
    private final String associationId;

    private final String networkAclId;

    private ReplaceNetworkAclAssociationRequest(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.networkAclId = builder.networkAclId;
    }

    /**
     * <p>
     * The ID of the current association between the original network ACL and the subnet.
     * </p>
     * 
     * @return The ID of the current association between the original network ACL and the subnet.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The ID of the new network ACL to associate with the subnet.
     * </p>
     * 
     * @return The ID of the new network ACL to associate with the subnet.
     */
    public String networkAclId() {
        return networkAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associationId() == null) ? 0 : associationId().hashCode());
        hashCode = 31 * hashCode + ((networkAclId() == null) ? 0 : networkAclId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclAssociationRequest)) {
            return false;
        }
        ReplaceNetworkAclAssociationRequest other = (ReplaceNetworkAclAssociationRequest) obj;
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        if (networkAclId() != null) {
            sb.append("NetworkAclId: ").append(networkAclId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        case "NetworkAclId":
            return Optional.of(clazz.cast(networkAclId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReplaceNetworkAclAssociationRequest> {
        /**
         * <p>
         * The ID of the current association between the original network ACL and the subnet.
         * </p>
         * 
         * @param associationId
         *        The ID of the current association between the original network ACL and the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The ID of the new network ACL to associate with the subnet.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the new network ACL to associate with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String networkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclAssociationRequest model) {
            associationId(model.associationId);
            networkAclId(model.networkAclId);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public ReplaceNetworkAclAssociationRequest build() {
            return new ReplaceNetworkAclAssociationRequest(this);
        }
    }
}
