/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Region implements ToCopyableBuilder<Region.Builder, Region> {
    private final String endpoint;

    private final String regionName;

    private Region(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.regionName = builder.regionName;
    }

    /**
     * <p>
     * The region service endpoint.
     * </p>
     * 
     * @return The region service endpoint.
     */
    public String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The name of the region.
     * </p>
     * 
     * @return The name of the region.
     */
    public String regionName() {
        return regionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((endpoint() == null) ? 0 : endpoint().hashCode());
        hashCode = 31 * hashCode + ((regionName() == null) ? 0 : regionName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region) obj;
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        if (other.regionName() != null && !other.regionName().equals(this.regionName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (endpoint() != null) {
            sb.append("Endpoint: ").append(endpoint()).append(",");
        }
        if (regionName() != null) {
            sb.append("RegionName: ").append(regionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoint":
            return Optional.of(clazz.cast(endpoint()));
        case "RegionName":
            return Optional.of(clazz.cast(regionName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Region> {
        /**
         * <p>
         * The region service endpoint.
         * </p>
         * 
         * @param endpoint
         *        The region service endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The name of the region.
         * </p>
         * 
         * @param regionName
         *        The name of the region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            endpoint(model.endpoint);
            regionName(model.regionName);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public Region build() {
            return new Region(this);
        }
    }
}
