/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseHostReservationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PurchaseHostReservationResponse.Builder, PurchaseHostReservationResponse> {
    private final String clientToken;

    private final String currencyCode;

    private final List<Purchase> purchase;

    private final String totalHourlyPrice;

    private final String totalUpfrontPrice;

    private PurchaseHostReservationResponse(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to
     *         Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified.
     * At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
     *         specified. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified.
     * At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
     *         specified. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeString() {
        return currencyCode;
    }

    /**
     * <p>
     * Describes the details of the purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Describes the details of the purchase.
     */
    public List<Purchase> purchase() {
        return purchase;
    }

    /**
     * <p>
     * The total hourly price of the reservation calculated per hour.
     * </p>
     * 
     * @return The total hourly price of the reservation calculated per hour.
     */
    public String totalHourlyPrice() {
        return totalHourlyPrice;
    }

    /**
     * <p>
     * The total amount that will be charged to your account when you purchase the reservation.
     * </p>
     * 
     * @return The total amount that will be charged to your account when you purchase the reservation.
     */
    public String totalUpfrontPrice() {
        return totalUpfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((currencyCodeString() == null) ? 0 : currencyCodeString().hashCode());
        hashCode = 31 * hashCode + ((purchase() == null) ? 0 : purchase().hashCode());
        hashCode = 31 * hashCode + ((totalHourlyPrice() == null) ? 0 : totalHourlyPrice().hashCode());
        hashCode = 31 * hashCode + ((totalUpfrontPrice() == null) ? 0 : totalUpfrontPrice().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationResponse)) {
            return false;
        }
        PurchaseHostReservationResponse other = (PurchaseHostReservationResponse) obj;
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.purchase() == null ^ this.purchase() == null) {
            return false;
        }
        if (other.purchase() != null && !other.purchase().equals(this.purchase())) {
            return false;
        }
        if (other.totalHourlyPrice() == null ^ this.totalHourlyPrice() == null) {
            return false;
        }
        if (other.totalHourlyPrice() != null && !other.totalHourlyPrice().equals(this.totalHourlyPrice())) {
            return false;
        }
        if (other.totalUpfrontPrice() == null ^ this.totalUpfrontPrice() == null) {
            return false;
        }
        if (other.totalUpfrontPrice() != null && !other.totalUpfrontPrice().equals(this.totalUpfrontPrice())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(currencyCodeString()).append(",");
        }
        if (purchase() != null) {
            sb.append("Purchase: ").append(purchase()).append(",");
        }
        if (totalHourlyPrice() != null) {
            sb.append("TotalHourlyPrice: ").append(totalHourlyPrice()).append(",");
        }
        if (totalUpfrontPrice() != null) {
            sb.append("TotalUpfrontPrice: ").append(totalUpfrontPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeString()));
        case "Purchase":
            return Optional.of(clazz.cast(purchase()));
        case "TotalHourlyPrice":
            return Optional.of(clazz.cast(totalHourlyPrice()));
        case "TotalUpfrontPrice":
            return Optional.of(clazz.cast(totalUpfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseHostReservationResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * Describes the details of the purchase.
         * </p>
         * 
         * @param purchase
         *        Describes the details of the purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Collection<Purchase> purchase);

        /**
         * <p>
         * Describes the details of the purchase.
         * </p>
         * 
         * @param purchase
         *        Describes the details of the purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Purchase... purchase);

        /**
         * <p>
         * The total hourly price of the reservation calculated per hour.
         * </p>
         * 
         * @param totalHourlyPrice
         *        The total hourly price of the reservation calculated per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalHourlyPrice(String totalHourlyPrice);

        /**
         * <p>
         * The total amount that will be charged to your account when you purchase the reservation.
         * </p>
         * 
         * @param totalUpfrontPrice
         *        The total amount that will be charged to your account when you purchase the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalUpfrontPrice(String totalUpfrontPrice);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private String currencyCode;

        private List<Purchase> purchase;

        private String totalHourlyPrice;

        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationResponse model) {
            clientToken(model.clientToken);
            currencyCode(model.currencyCode);
            purchase(model.purchase);
            totalHourlyPrice(model.totalHourlyPrice);
            totalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<Purchase.Builder> getPurchase() {
            return purchase != null ? purchase.stream().map(Purchase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase... purchase) {
            purchase(Arrays.asList(purchase));
            return this;
        }

        public final void setPurchase(Collection<Purchase.BuilderImpl> purchase) {
            this.purchase = PurchaseSetCopier.copyFromBuilder(purchase);
        }

        public final String getTotalHourlyPrice() {
            return totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        @Override
        public PurchaseHostReservationResponse build() {
            return new PurchaseHostReservationResponse(this);
        }
    }
}
