/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an entry in a network ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkAclEntry implements ToCopyableBuilder<NetworkAclEntry.Builder, NetworkAclEntry> {
    private final String cidrBlock;

    private final Boolean egress;

    private final IcmpTypeCode icmpTypeCode;

    private final String ipv6CidrBlock;

    private final PortRange portRange;

    private final String protocol;

    private final String ruleAction;

    private final Integer ruleNumber;

    private NetworkAclEntry(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    /**
     * <p>
     * The IPv4 network range to allow or deny, in CIDR notation.
     * </p>
     * 
     * @return The IPv4 network range to allow or deny, in CIDR notation.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
     * </p>
     * 
     * @return Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
     */
    public Boolean egress() {
        return egress;
    }

    /**
     * <p>
     * ICMP protocol: The ICMP type and code.
     * </p>
     * 
     * @return ICMP protocol: The ICMP type and code.
     */
    public IcmpTypeCode icmpTypeCode() {
        return icmpTypeCode;
    }

    /**
     * <p>
     * The IPv6 network range to allow or deny, in CIDR notation.
     * </p>
     * 
     * @return The IPv6 network range to allow or deny, in CIDR notation.
     */
    public String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * TCP or UDP protocols: The range of ports the rule applies to.
     * </p>
     * 
     * @return TCP or UDP protocols: The range of ports the rule applies to.
     */
    public PortRange portRange() {
        return portRange;
    }

    /**
     * <p>
     * The protocol. A value of <code>-1</code> means all protocols.
     * </p>
     * 
     * @return The protocol. A value of <code>-1</code> means all protocols.
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public RuleAction ruleAction() {
        return RuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public String ruleActionString() {
        return ruleAction;
    }

    /**
     * <p>
     * The rule number for the entry. ACL entries are processed in ascending order by rule number.
     * </p>
     * 
     * @return The rule number for the entry. ACL entries are processed in ascending order by rule number.
     */
    public Integer ruleNumber() {
        return ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrBlock() == null) ? 0 : cidrBlock().hashCode());
        hashCode = 31 * hashCode + ((egress() == null) ? 0 : egress().hashCode());
        hashCode = 31 * hashCode + ((icmpTypeCode() == null) ? 0 : icmpTypeCode().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlock() == null) ? 0 : ipv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + ((portRange() == null) ? 0 : portRange().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        hashCode = 31 * hashCode + ((ruleActionString() == null) ? 0 : ruleActionString().hashCode());
        hashCode = 31 * hashCode + ((ruleNumber() == null) ? 0 : ruleNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclEntry)) {
            return false;
        }
        NetworkAclEntry other = (NetworkAclEntry) obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.egress() == null ^ this.egress() == null) {
            return false;
        }
        if (other.egress() != null && !other.egress().equals(this.egress())) {
            return false;
        }
        if (other.icmpTypeCode() == null ^ this.icmpTypeCode() == null) {
            return false;
        }
        if (other.icmpTypeCode() != null && !other.icmpTypeCode().equals(this.icmpTypeCode())) {
            return false;
        }
        if (other.ipv6CidrBlock() == null ^ this.ipv6CidrBlock() == null) {
            return false;
        }
        if (other.ipv6CidrBlock() != null && !other.ipv6CidrBlock().equals(this.ipv6CidrBlock())) {
            return false;
        }
        if (other.portRange() == null ^ this.portRange() == null) {
            return false;
        }
        if (other.portRange() != null && !other.portRange().equals(this.portRange())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.ruleActionString() == null ^ this.ruleActionString() == null) {
            return false;
        }
        if (other.ruleActionString() != null && !other.ruleActionString().equals(this.ruleActionString())) {
            return false;
        }
        if (other.ruleNumber() == null ^ this.ruleNumber() == null) {
            return false;
        }
        if (other.ruleNumber() != null && !other.ruleNumber().equals(this.ruleNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (egress() != null) {
            sb.append("Egress: ").append(egress()).append(",");
        }
        if (icmpTypeCode() != null) {
            sb.append("IcmpTypeCode: ").append(icmpTypeCode()).append(",");
        }
        if (ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(ipv6CidrBlock()).append(",");
        }
        if (portRange() != null) {
            sb.append("PortRange: ").append(portRange()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        if (ruleActionString() != null) {
            sb.append("RuleAction: ").append(ruleActionString()).append(",");
        }
        if (ruleNumber() != null) {
            sb.append("RuleNumber: ").append(ruleNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.of(clazz.cast(cidrBlock()));
        case "Egress":
            return Optional.of(clazz.cast(egress()));
        case "IcmpTypeCode":
            return Optional.of(clazz.cast(icmpTypeCode()));
        case "Ipv6CidrBlock":
            return Optional.of(clazz.cast(ipv6CidrBlock()));
        case "PortRange":
            return Optional.of(clazz.cast(portRange()));
        case "Protocol":
            return Optional.of(clazz.cast(protocol()));
        case "RuleAction":
            return Optional.of(clazz.cast(ruleActionString()));
        case "RuleNumber":
            return Optional.of(clazz.cast(ruleNumber()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkAclEntry> {
        /**
         * <p>
         * The IPv4 network range to allow or deny, in CIDR notation.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range to allow or deny, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
         * </p>
         * 
         * @param egress
         *        Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        /**
         * <p>
         * ICMP protocol: The ICMP type and code.
         * </p>
         * 
         * @param icmpTypeCode
         *        ICMP protocol: The ICMP type and code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icmpTypeCode(IcmpTypeCode icmpTypeCode);

        /**
         * <p>
         * The IPv6 network range to allow or deny, in CIDR notation.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 network range to allow or deny, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * TCP or UDP protocols: The range of ports the rule applies to.
         * </p>
         * 
         * @param portRange
         *        TCP or UDP protocols: The range of ports the rule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRange portRange);

        /**
         * <p>
         * The protocol. A value of <code>-1</code> means all protocols.
         * </p>
         * 
         * @param protocol
         *        The protocol. A value of <code>-1</code> means all protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(RuleAction ruleAction);

        /**
         * <p>
         * The rule number for the entry. ACL entries are processed in ascending order by rule number.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number for the entry. ACL entries are processed in ascending order by rule number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);
    }

    static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private Boolean egress;

        private IcmpTypeCode icmpTypeCode;

        private String ipv6CidrBlock;

        private PortRange portRange;

        private String protocol;

        private String ruleAction;

        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclEntry model) {
            cidrBlock(model.cidrBlock);
            egress(model.egress);
            icmpTypeCode(model.icmpTypeCode);
            ipv6CidrBlock(model.ipv6CidrBlock);
            portRange(model.portRange);
            protocol(model.protocol);
            ruleAction(model.ruleAction);
            ruleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return icmpTypeCode != null ? icmpTypeCode.toBuilder() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final PortRange.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public NetworkAclEntry build() {
            return new NetworkAclEntry(this);
        }
    }
}
