/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of MonitorInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MonitorInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<MonitorInstancesResponse.Builder, MonitorInstancesResponse> {
    private final List<InstanceMonitoring> instanceMonitorings;

    private MonitorInstancesResponse(BuilderImpl builder) {
        this.instanceMonitorings = builder.instanceMonitorings;
    }

    /**
     * <p>
     * The monitoring information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The monitoring information.
     */
    public List<InstanceMonitoring> instanceMonitorings() {
        return instanceMonitorings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceMonitorings() == null) ? 0 : instanceMonitorings().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorInstancesResponse)) {
            return false;
        }
        MonitorInstancesResponse other = (MonitorInstancesResponse) obj;
        if (other.instanceMonitorings() == null ^ this.instanceMonitorings() == null) {
            return false;
        }
        if (other.instanceMonitorings() != null && !other.instanceMonitorings().equals(this.instanceMonitorings())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceMonitorings() != null) {
            sb.append("InstanceMonitorings: ").append(instanceMonitorings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceMonitorings":
            return Optional.of(clazz.cast(instanceMonitorings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, MonitorInstancesResponse> {
        /**
         * <p>
         * The monitoring information.
         * </p>
         * 
         * @param instanceMonitorings
         *        The monitoring information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings);

        /**
         * <p>
         * The monitoring information.
         * </p>
         * 
         * @param instanceMonitorings
         *        The monitoring information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitorings(InstanceMonitoring... instanceMonitorings);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceMonitoring> instanceMonitorings;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorInstancesResponse model) {
            instanceMonitorings(model.instanceMonitorings);
        }

        public final Collection<InstanceMonitoring.Builder> getInstanceMonitorings() {
            return instanceMonitorings != null ? instanceMonitorings.stream().map(InstanceMonitoring::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copy(instanceMonitorings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(InstanceMonitoring... instanceMonitorings) {
            instanceMonitorings(Arrays.asList(instanceMonitorings));
            return this;
        }

        public final void setInstanceMonitorings(Collection<InstanceMonitoring.BuilderImpl> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copyFromBuilder(instanceMonitorings);
        }

        @Override
        public MonitorInstancesResponse build() {
            return new MonitorInstancesResponse(this);
        }
    }
}
