/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifySpotFleetRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifySpotFleetRequestRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifySpotFleetRequestRequest.Builder, ModifySpotFleetRequestRequest> {
    private final String excessCapacityTerminationPolicy;

    private final String spotFleetRequestId;

    private final Integer targetCapacity;

    private ModifySpotFleetRequestRequest(BuilderImpl builder) {
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.targetCapacity = builder.targetCapacity;
    }

    /**
     * <p>
     * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is
     * decreased below the current size of the Spot fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyString}.
     * </p>
     * 
     * @return Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
     *         request is decreased below the current size of the Spot fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is
     * decreased below the current size of the Spot fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyString}.
     * </p>
     * 
     * @return Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
     *         request is decreased below the current size of the Spot fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public String excessCapacityTerminationPolicyString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    /**
     * <p>
     * The size of the fleet.
     * </p>
     * 
     * @return The size of the fleet.
     */
    public Integer targetCapacity() {
        return targetCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((excessCapacityTerminationPolicyString() == null) ? 0 : excessCapacityTerminationPolicyString().hashCode());
        hashCode = 31 * hashCode + ((spotFleetRequestId() == null) ? 0 : spotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + ((targetCapacity() == null) ? 0 : targetCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySpotFleetRequestRequest)) {
            return false;
        }
        ModifySpotFleetRequestRequest other = (ModifySpotFleetRequestRequest) obj;
        if (other.excessCapacityTerminationPolicyString() == null ^ this.excessCapacityTerminationPolicyString() == null) {
            return false;
        }
        if (other.excessCapacityTerminationPolicyString() != null
                && !other.excessCapacityTerminationPolicyString().equals(this.excessCapacityTerminationPolicyString())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        if (other.targetCapacity() == null ^ this.targetCapacity() == null) {
            return false;
        }
        if (other.targetCapacity() != null && !other.targetCapacity().equals(this.targetCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (excessCapacityTerminationPolicyString() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(excessCapacityTerminationPolicyString()).append(",");
        }
        if (spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(spotFleetRequestId()).append(",");
        }
        if (targetCapacity() != null) {
            sb.append("TargetCapacity: ").append(targetCapacity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcessCapacityTerminationPolicy":
            return Optional.of(clazz.cast(excessCapacityTerminationPolicyString()));
        case "SpotFleetRequestId":
            return Optional.of(clazz.cast(spotFleetRequestId()));
        case "TargetCapacity":
            return Optional.of(clazz.cast(targetCapacity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ModifySpotFleetRequestRequest> {
        /**
         * <p>
         * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         * request is decreased below the current size of the Spot fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         *        request is decreased below the current size of the Spot fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         * request is decreased below the current size of the Spot fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         *        request is decreased below the current size of the Spot fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);

        /**
         * <p>
         * The size of the fleet.
         * </p>
         * 
         * @param targetCapacity
         *        The size of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacity(Integer targetCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String excessCapacityTerminationPolicy;

        private String spotFleetRequestId;

        private Integer targetCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySpotFleetRequestRequest model) {
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            spotFleetRequestId(model.spotFleetRequestId);
            targetCapacity(model.targetCapacity);
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final Integer getTargetCapacity() {
            return targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        @Override
        public ModifySpotFleetRequestRequest build() {
            return new ModifySpotFleetRequestRequest(this);
        }
    }
}
