/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyReservedInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyReservedInstancesRequest.Builder, ModifyReservedInstancesRequest> {
    private final List<String> reservedInstancesIds;

    private final String clientToken;

    private final List<ReservedInstancesConfiguration> targetConfigurations;

    private ModifyReservedInstancesRequest(BuilderImpl builder) {
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.clientToken = builder.clientToken;
        this.targetConfigurations = builder.targetConfigurations;
    }

    /**
     * <p>
     * The IDs of the Reserved Instances to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Reserved Instances to modify.
     */
    public List<String> reservedInstancesIds() {
        return reservedInstancesIds;
    }

    /**
     * <p>
     * A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration settings for the Reserved Instances to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The configuration settings for the Reserved Instances to modify.
     */
    public List<ReservedInstancesConfiguration> targetConfigurations() {
        return targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservedInstancesIds() == null) ? 0 : reservedInstancesIds().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((targetConfigurations() == null) ? 0 : targetConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest) obj;
        if (other.reservedInstancesIds() == null ^ this.reservedInstancesIds() == null) {
            return false;
        }
        if (other.reservedInstancesIds() != null && !other.reservedInstancesIds().equals(this.reservedInstancesIds())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.targetConfigurations() == null ^ this.targetConfigurations() == null) {
            return false;
        }
        if (other.targetConfigurations() != null && !other.targetConfigurations().equals(this.targetConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(reservedInstancesIds()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (targetConfigurations() != null) {
            sb.append("TargetConfigurations: ").append(targetConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesIds":
            return Optional.of(clazz.cast(reservedInstancesIds()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "TargetConfigurations":
            return Optional.of(clazz.cast(targetConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyReservedInstancesRequest> {
        /**
         * <p>
         * The IDs of the Reserved Instances to modify.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(Collection<String> reservedInstancesIds);

        /**
         * <p>
         * The IDs of the Reserved Instances to modify.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(String... reservedInstancesIds);

        /**
         * <p>
         * A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token you provide to ensure idempotency of your modification request. For
         *        more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration settings for the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration settings for the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(ReservedInstancesConfiguration... targetConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<String> reservedInstancesIds;

        private String clientToken;

        private List<ReservedInstancesConfiguration> targetConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReservedInstancesRequest model) {
            reservedInstancesIds(model.reservedInstancesIds);
            clientToken(model.clientToken);
            targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstancesIds() {
            return reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String... reservedInstancesIds) {
            reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<ReservedInstancesConfiguration.Builder> getTargetConfigurations() {
            return targetConfigurations != null ? targetConfigurations.stream().map(ReservedInstancesConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(ReservedInstancesConfiguration... targetConfigurations) {
            targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        public final void setTargetConfigurations(Collection<ReservedInstancesConfiguration.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public ModifyReservedInstancesRequest build() {
            return new ModifyReservedInstancesRequest(this);
        }
    }
}
