/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyImageAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyImageAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyImageAttributeRequest.Builder, ModifyImageAttributeRequest> {
    private final String attribute;

    private final String description;

    private final String imageId;

    private final LaunchPermissionModifications launchPermission;

    private final String operationType;

    private final List<String> productCodes;

    private final List<String> userGroups;

    private final List<String> userIds;

    private final String value;

    private ModifyImageAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.description = builder.description;
        this.imageId = builder.imageId;
        this.launchPermission = builder.launchPermission;
        this.operationType = builder.operationType;
        this.productCodes = builder.productCodes;
        this.userGroups = builder.userGroups;
        this.userIds = builder.userIds;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute to modify.
     * </p>
     * 
     * @return The name of the attribute to modify.
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * A description for the AMI.
     * </p>
     * 
     * @return A description for the AMI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * A launch permission modification.
     * </p>
     * 
     * @return A launch permission modification.
     */
    public LaunchPermissionModifications launchPermission() {
        return launchPermission;
    }

    /**
     * <p>
     * The operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeString}.
     * </p>
     * 
     * @return The operation type.
     * @see OperationType
     */
    public OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeString}.
     * </p>
     * 
     * @return The operation type.
     * @see OperationType
     */
    public String operationTypeString() {
        return operationType;
    }

    /**
     * <p>
     * One or more product codes. After you add a product code to an AMI, it can't be removed. This is only valid when
     * modifying the <code>productCodes</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more product codes. After you add a product code to an AMI, it can't be removed. This is only
     *         valid when modifying the <code>productCodes</code> attribute.
     */
    public List<String> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * One or more user groups. This is only valid when modifying the <code>launchPermission</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user groups. This is only valid when modifying the <code>launchPermission</code> attribute.
     */
    public List<String> userGroups() {
        return userGroups;
    }

    /**
     * <p>
     * One or more AWS account IDs. This is only valid when modifying the <code>launchPermission</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more AWS account IDs. This is only valid when modifying the <code>launchPermission</code>
     *         attribute.
     */
    public List<String> userIds() {
        return userIds;
    }

    /**
     * <p>
     * The value of the attribute being modified. This is only valid when modifying the <code>description</code>
     * attribute.
     * </p>
     * 
     * @return The value of the attribute being modified. This is only valid when modifying the <code>description</code>
     *         attribute.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((launchPermission() == null) ? 0 : launchPermission().hashCode());
        hashCode = 31 * hashCode + ((operationTypeString() == null) ? 0 : operationTypeString().hashCode());
        hashCode = 31 * hashCode + ((productCodes() == null) ? 0 : productCodes().hashCode());
        hashCode = 31 * hashCode + ((userGroups() == null) ? 0 : userGroups().hashCode());
        hashCode = 31 * hashCode + ((userIds() == null) ? 0 : userIds().hashCode());
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyImageAttributeRequest)) {
            return false;
        }
        ModifyImageAttributeRequest other = (ModifyImageAttributeRequest) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.launchPermission() == null ^ this.launchPermission() == null) {
            return false;
        }
        if (other.launchPermission() != null && !other.launchPermission().equals(this.launchPermission())) {
            return false;
        }
        if (other.operationTypeString() == null ^ this.operationTypeString() == null) {
            return false;
        }
        if (other.operationTypeString() != null && !other.operationTypeString().equals(this.operationTypeString())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.userGroups() == null ^ this.userGroups() == null) {
            return false;
        }
        if (other.userGroups() != null && !other.userGroups().equals(this.userGroups())) {
            return false;
        }
        if (other.userIds() == null ^ this.userIds() == null) {
            return false;
        }
        if (other.userIds() != null && !other.userIds().equals(this.userIds())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (launchPermission() != null) {
            sb.append("LaunchPermission: ").append(launchPermission()).append(",");
        }
        if (operationTypeString() != null) {
            sb.append("OperationType: ").append(operationTypeString()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (userGroups() != null) {
            sb.append("UserGroups: ").append(userGroups()).append(",");
        }
        if (userIds() != null) {
            sb.append("UserIds: ").append(userIds()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.of(clazz.cast(attribute()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "LaunchPermission":
            return Optional.of(clazz.cast(launchPermission()));
        case "OperationType":
            return Optional.of(clazz.cast(operationTypeString()));
        case "ProductCodes":
            return Optional.of(clazz.cast(productCodes()));
        case "UserGroups":
            return Optional.of(clazz.cast(userGroups()));
        case "UserIds":
            return Optional.of(clazz.cast(userIds()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyImageAttributeRequest> {
        /**
         * <p>
         * The name of the attribute to modify.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * A description for the AMI.
         * </p>
         * 
         * @param description
         *        A description for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * A launch permission modification.
         * </p>
         * 
         * @param launchPermission
         *        A launch permission modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermission(LaunchPermissionModifications launchPermission);

        /**
         * <p>
         * The operation type.
         * </p>
         * 
         * @param operationType
         *        The operation type.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The operation type.
         * </p>
         * 
         * @param operationType
         *        The operation type.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * One or more product codes. After you add a product code to an AMI, it can't be removed. This is only valid
         * when modifying the <code>productCodes</code> attribute.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes. After you add a product code to an AMI, it can't be removed. This is only
         *        valid when modifying the <code>productCodes</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<String> productCodes);

        /**
         * <p>
         * One or more product codes. After you add a product code to an AMI, it can't be removed. This is only valid
         * when modifying the <code>productCodes</code> attribute.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes. After you add a product code to an AMI, it can't be removed. This is only
         *        valid when modifying the <code>productCodes</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(String... productCodes);

        /**
         * <p>
         * One or more user groups. This is only valid when modifying the <code>launchPermission</code> attribute.
         * </p>
         * 
         * @param userGroups
         *        One or more user groups. This is only valid when modifying the <code>launchPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * One or more user groups. This is only valid when modifying the <code>launchPermission</code> attribute.
         * </p>
         * 
         * @param userGroups
         *        One or more user groups. This is only valid when modifying the <code>launchPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);

        /**
         * <p>
         * One or more AWS account IDs. This is only valid when modifying the <code>launchPermission</code> attribute.
         * </p>
         * 
         * @param userIds
         *        One or more AWS account IDs. This is only valid when modifying the <code>launchPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * One or more AWS account IDs. This is only valid when modifying the <code>launchPermission</code> attribute.
         * </p>
         * 
         * @param userIds
         *        One or more AWS account IDs. This is only valid when modifying the <code>launchPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * The value of the attribute being modified. This is only valid when modifying the <code>description</code>
         * attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute being modified. This is only valid when modifying the
         *        <code>description</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String description;

        private String imageId;

        private LaunchPermissionModifications launchPermission;

        private String operationType;

        private List<String> productCodes;

        private List<String> userGroups;

        private List<String> userIds;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyImageAttributeRequest model) {
            attribute(model.attribute);
            description(model.description);
            imageId(model.imageId);
            launchPermission(model.launchPermission);
            operationType(model.operationType);
            productCodes(model.productCodes);
            userGroups(model.userGroups);
            userIds(model.userIds);
            value(model.value);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final LaunchPermissionModifications.Builder getLaunchPermission() {
            return launchPermission != null ? launchPermission.toBuilder() : null;
        }

        @Override
        public final Builder launchPermission(LaunchPermissionModifications launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        public final void setLaunchPermission(LaunchPermissionModifications.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        public final String getOperationType() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final Collection<String> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        public final Collection<String> getUserGroups() {
            return userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        public final Collection<String> getUserIds() {
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ModifyImageAttributeRequest build() {
            return new ModifyImageAttributeRequest(this);
        }
    }
}
