/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum InstanceType {
    T1_MICRO("t1.micro"),

    T2_NANO("t2.nano"),

    T2_MICRO("t2.micro"),

    T2_SMALL("t2.small"),

    T2_MEDIUM("t2.medium"),

    T2_LARGE("t2.large"),

    T2_XLARGE("t2.xlarge"),

    T2_2_XLARGE("t2.2xlarge"),

    M1_SMALL("m1.small"),

    M1_MEDIUM("m1.medium"),

    M1_LARGE("m1.large"),

    M1_XLARGE("m1.xlarge"),

    M3_MEDIUM("m3.medium"),

    M3_LARGE("m3.large"),

    M3_XLARGE("m3.xlarge"),

    M3_2_XLARGE("m3.2xlarge"),

    M4_LARGE("m4.large"),

    M4_XLARGE("m4.xlarge"),

    M4_2_XLARGE("m4.2xlarge"),

    M4_4_XLARGE("m4.4xlarge"),

    M4_10_XLARGE("m4.10xlarge"),

    M4_16_XLARGE("m4.16xlarge"),

    M2_XLARGE("m2.xlarge"),

    M2_2_XLARGE("m2.2xlarge"),

    M2_4_XLARGE("m2.4xlarge"),

    CR1_8_XLARGE("cr1.8xlarge"),

    R3_LARGE("r3.large"),

    R3_XLARGE("r3.xlarge"),

    R3_2_XLARGE("r3.2xlarge"),

    R3_4_XLARGE("r3.4xlarge"),

    R3_8_XLARGE("r3.8xlarge"),

    R4_LARGE("r4.large"),

    R4_XLARGE("r4.xlarge"),

    R4_2_XLARGE("r4.2xlarge"),

    R4_4_XLARGE("r4.4xlarge"),

    R4_8_XLARGE("r4.8xlarge"),

    R4_16_XLARGE("r4.16xlarge"),

    X1_16_XLARGE("x1.16xlarge"),

    X1_32_XLARGE("x1.32xlarge"),

    I2_XLARGE("i2.xlarge"),

    I2_2_XLARGE("i2.2xlarge"),

    I2_4_XLARGE("i2.4xlarge"),

    I2_8_XLARGE("i2.8xlarge"),

    I3_LARGE("i3.large"),

    I3_XLARGE("i3.xlarge"),

    I3_2_XLARGE("i3.2xlarge"),

    I3_4_XLARGE("i3.4xlarge"),

    I3_8_XLARGE("i3.8xlarge"),

    I3_16_XLARGE("i3.16xlarge"),

    HI1_4_XLARGE("hi1.4xlarge"),

    HS1_8_XLARGE("hs1.8xlarge"),

    C1_MEDIUM("c1.medium"),

    C1_XLARGE("c1.xlarge"),

    C3_LARGE("c3.large"),

    C3_XLARGE("c3.xlarge"),

    C3_2_XLARGE("c3.2xlarge"),

    C3_4_XLARGE("c3.4xlarge"),

    C3_8_XLARGE("c3.8xlarge"),

    C4_LARGE("c4.large"),

    C4_XLARGE("c4.xlarge"),

    C4_2_XLARGE("c4.2xlarge"),

    C4_4_XLARGE("c4.4xlarge"),

    C4_8_XLARGE("c4.8xlarge"),

    CC1_4_XLARGE("cc1.4xlarge"),

    CC2_8_XLARGE("cc2.8xlarge"),

    G2_2_XLARGE("g2.2xlarge"),

    G2_8_XLARGE("g2.8xlarge"),

    CG1_4_XLARGE("cg1.4xlarge"),

    P2_XLARGE("p2.xlarge"),

    P2_8_XLARGE("p2.8xlarge"),

    P2_16_XLARGE("p2.16xlarge"),

    D2_XLARGE("d2.xlarge"),

    D2_2_XLARGE("d2.2xlarge"),

    D2_4_XLARGE("d2.4xlarge"),

    D2_8_XLARGE("d2.8xlarge"),

    F1_2_XLARGE("f1.2xlarge"),

    F1_16_XLARGE("f1.16xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InstanceType corresponding to the value
     */
    public static InstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InstanceType}s
     */
    public static Set<InstanceType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
