/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a scheduled event for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStatusEvent implements ToCopyableBuilder<InstanceStatusEvent.Builder, InstanceStatusEvent> {
    private final String code;

    private final String description;

    private final Instant notAfter;

    private final Instant notBefore;

    private InstanceStatusEvent(BuilderImpl builder) {
        this.code = builder.code;
        this.description = builder.description;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
    }

    /**
     * <p>
     * The event code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link EventCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeString}.
     * </p>
     * 
     * @return The event code.
     * @see EventCode
     */
    public EventCode code() {
        return EventCode.fromValue(code);
    }

    /**
     * <p>
     * The event code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link EventCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeString}.
     * </p>
     * 
     * @return The event code.
     * @see EventCode
     */
    public String codeString() {
        return code;
    }

    /**
     * <p>
     * A description of the event.
     * </p>
     * <p>
     * After a scheduled event is completed, it can still be described for up to a week. If the event has been
     * completed, this description starts with the following text: [Completed].
     * </p>
     * 
     * @return A description of the event.</p>
     *         <p>
     *         After a scheduled event is completed, it can still be described for up to a week. If the event has been
     *         completed, this description starts with the following text: [Completed].
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The latest scheduled end time for the event.
     * </p>
     * 
     * @return The latest scheduled end time for the event.
     */
    public Instant notAfter() {
        return notAfter;
    }

    /**
     * <p>
     * The earliest scheduled start time for the event.
     * </p>
     * 
     * @return The earliest scheduled start time for the event.
     */
    public Instant notBefore() {
        return notBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((codeString() == null) ? 0 : codeString().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((notAfter() == null) ? 0 : notAfter().hashCode());
        hashCode = 31 * hashCode + ((notBefore() == null) ? 0 : notBefore().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusEvent)) {
            return false;
        }
        InstanceStatusEvent other = (InstanceStatusEvent) obj;
        if (other.codeString() == null ^ this.codeString() == null) {
            return false;
        }
        if (other.codeString() != null && !other.codeString().equals(this.codeString())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.notAfter() == null ^ this.notAfter() == null) {
            return false;
        }
        if (other.notAfter() != null && !other.notAfter().equals(this.notAfter())) {
            return false;
        }
        if (other.notBefore() == null ^ this.notBefore() == null) {
            return false;
        }
        if (other.notBefore() != null && !other.notBefore().equals(this.notBefore())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (codeString() != null) {
            sb.append("Code: ").append(codeString()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (notAfter() != null) {
            sb.append("NotAfter: ").append(notAfter()).append(",");
        }
        if (notBefore() != null) {
            sb.append("NotBefore: ").append(notBefore()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.of(clazz.cast(codeString()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "NotAfter":
            return Optional.of(clazz.cast(notAfter()));
        case "NotBefore":
            return Optional.of(clazz.cast(notBefore()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStatusEvent> {
        /**
         * <p>
         * The event code.
         * </p>
         * 
         * @param code
         *        The event code.
         * @see EventCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventCode
         */
        Builder code(String code);

        /**
         * <p>
         * The event code.
         * </p>
         * 
         * @param code
         *        The event code.
         * @see EventCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventCode
         */
        Builder code(EventCode code);

        /**
         * <p>
         * A description of the event.
         * </p>
         * <p>
         * After a scheduled event is completed, it can still be described for up to a week. If the event has been
         * completed, this description starts with the following text: [Completed].
         * </p>
         * 
         * @param description
         *        A description of the event.</p>
         *        <p>
         *        After a scheduled event is completed, it can still be described for up to a week. If the event has
         *        been completed, this description starts with the following text: [Completed].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The latest scheduled end time for the event.
         * </p>
         * 
         * @param notAfter
         *        The latest scheduled end time for the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfter(Instant notAfter);

        /**
         * <p>
         * The earliest scheduled start time for the event.
         * </p>
         * 
         * @param notBefore
         *        The earliest scheduled start time for the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBefore(Instant notBefore);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String description;

        private Instant notAfter;

        private Instant notBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusEvent model) {
            code(model.code);
            description(model.description);
            notAfter(model.notAfter);
            notBefore(model.notBefore);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(EventCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getNotAfter() {
            return notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public InstanceStatusEvent build() {
            return new InstanceStatusEvent(this);
        }
    }
}
