/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance state change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStateChange implements ToCopyableBuilder<InstanceStateChange.Builder, InstanceStateChange> {
    private final InstanceState currentState;

    private final String instanceId;

    private final InstanceState previousState;

    private InstanceStateChange(BuilderImpl builder) {
        this.currentState = builder.currentState;
        this.instanceId = builder.instanceId;
        this.previousState = builder.previousState;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public InstanceState currentState() {
        return currentState;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The previous state of the instance.
     * </p>
     * 
     * @return The previous state of the instance.
     */
    public InstanceState previousState() {
        return previousState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((currentState() == null) ? 0 : currentState().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((previousState() == null) ? 0 : previousState().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStateChange)) {
            return false;
        }
        InstanceStateChange other = (InstanceStateChange) obj;
        if (other.currentState() == null ^ this.currentState() == null) {
            return false;
        }
        if (other.currentState() != null && !other.currentState().equals(this.currentState())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.previousState() == null ^ this.previousState() == null) {
            return false;
        }
        if (other.previousState() != null && !other.previousState().equals(this.previousState())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (currentState() != null) {
            sb.append("CurrentState: ").append(currentState()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (previousState() != null) {
            sb.append("PreviousState: ").append(previousState()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentState":
            return Optional.of(clazz.cast(currentState()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "PreviousState":
            return Optional.of(clazz.cast(previousState()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStateChange> {
        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param currentState
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentState(InstanceState currentState);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The previous state of the instance.
         * </p>
         * 
         * @param previousState
         *        The previous state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousState(InstanceState previousState);
    }

    static final class BuilderImpl implements Builder {
        private InstanceState currentState;

        private String instanceId;

        private InstanceState previousState;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStateChange model) {
            currentState(model.currentState);
            instanceId(model.instanceId);
            previousState(model.previousState);
        }

        public final InstanceState.Builder getCurrentState() {
            return currentState != null ? currentState.toBuilder() : null;
        }

        @Override
        public final Builder currentState(InstanceState currentState) {
            this.currentState = currentState;
            return this;
        }

        public final void setCurrentState(InstanceState.BuilderImpl currentState) {
            this.currentState = currentState != null ? currentState.build() : null;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState.Builder getPreviousState() {
            return previousState != null ? previousState.toBuilder() : null;
        }

        @Override
        public final Builder previousState(InstanceState previousState) {
            this.previousState = previousState;
            return this;
        }

        public final void setPreviousState(InstanceState.BuilderImpl previousState) {
            this.previousState = previousState != null ? previousState.build() : null;
        }

        @Override
        public InstanceStateChange build() {
            return new InstanceStateChange(this);
        }
    }
}
