/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import volume task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportVolumeTaskDetails implements ToCopyableBuilder<ImportVolumeTaskDetails.Builder, ImportVolumeTaskDetails> {
    private final String availabilityZone;

    private final Long bytesConverted;

    private final String description;

    private final DiskImageDescription image;

    private final DiskImageVolumeDescription volume;

    private ImportVolumeTaskDetails(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.bytesConverted = builder.bytesConverted;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    /**
     * <p>
     * The Availability Zone where the resulting volume will reside.
     * </p>
     * 
     * @return The Availability Zone where the resulting volume will reside.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of bytes converted so far.
     * </p>
     * 
     * @return The number of bytes converted so far.
     */
    public Long bytesConverted() {
        return bytesConverted;
    }

    /**
     * <p>
     * The description you provided when starting the import volume task.
     * </p>
     * 
     * @return The description you provided when starting the import volume task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The image.
     * </p>
     * 
     * @return The image.
     */
    public DiskImageDescription image() {
        return image;
    }

    /**
     * <p>
     * The volume.
     * </p>
     * 
     * @return The volume.
     */
    public DiskImageVolumeDescription volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((bytesConverted() == null) ? 0 : bytesConverted().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((image() == null) ? 0 : image().hashCode());
        hashCode = 31 * hashCode + ((volume() == null) ? 0 : volume().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeTaskDetails)) {
            return false;
        }
        ImportVolumeTaskDetails other = (ImportVolumeTaskDetails) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.bytesConverted() == null ^ this.bytesConverted() == null) {
            return false;
        }
        if (other.bytesConverted() != null && !other.bytesConverted().equals(this.bytesConverted())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.volume() == null ^ this.volume() == null) {
            return false;
        }
        if (other.volume() != null && !other.volume().equals(this.volume())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (bytesConverted() != null) {
            sb.append("BytesConverted: ").append(bytesConverted()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (volume() != null) {
            sb.append("Volume: ").append(volume()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "BytesConverted":
            return Optional.of(clazz.cast(bytesConverted()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Image":
            return Optional.of(clazz.cast(image()));
        case "Volume":
            return Optional.of(clazz.cast(volume()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImportVolumeTaskDetails> {
        /**
         * <p>
         * The Availability Zone where the resulting volume will reside.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the resulting volume will reside.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of bytes converted so far.
         * </p>
         * 
         * @param bytesConverted
         *        The number of bytes converted so far.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesConverted(Long bytesConverted);

        /**
         * <p>
         * The description you provided when starting the import volume task.
         * </p>
         * 
         * @param description
         *        The description you provided when starting the import volume task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The image.
         * </p>
         * 
         * @param image
         *        The image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(DiskImageDescription image);

        /**
         * <p>
         * The volume.
         * </p>
         * 
         * @param volume
         *        The volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(DiskImageVolumeDescription volume);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Long bytesConverted;

        private String description;

        private DiskImageDescription image;

        private DiskImageVolumeDescription volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeTaskDetails model) {
            availabilityZone(model.availabilityZone);
            bytesConverted(model.bytesConverted);
            description(model.description);
            image(model.image);
            volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getBytesConverted() {
            return bytesConverted;
        }

        @Override
        public final Builder bytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
            return this;
        }

        public final void setBytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDescription.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(DiskImageDescription image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDescription.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final DiskImageVolumeDescription.Builder getVolume() {
            return volume != null ? volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(DiskImageVolumeDescription volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(DiskImageVolumeDescription.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public ImportVolumeTaskDetails build() {
            return new ImportVolumeTaskDetails(this);
        }
    }
}
