/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the ID format for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdFormat implements ToCopyableBuilder<IdFormat.Builder, IdFormat> {
    private final Instant deadline;

    private final String resource;

    private final Boolean useLongIds;

    private IdFormat(BuilderImpl builder) {
        this.deadline = builder.deadline;
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    /**
     * <p>
     * The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet
     * available for this resource type, this field is not returned.
     * </p>
     * 
     * @return The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet
     *         available for this resource type, this field is not returned.
     */
    public Instant deadline() {
        return deadline;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * 
     * @return The type of resource.
     */
    public String resource() {
        return resource;
    }

    /**
     * <p>
     * Indicates whether longer IDs (17-character IDs) are enabled for the resource.
     * </p>
     * 
     * @return Indicates whether longer IDs (17-character IDs) are enabled for the resource.
     */
    public Boolean useLongIds() {
        return useLongIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deadline() == null) ? 0 : deadline().hashCode());
        hashCode = 31 * hashCode + ((resource() == null) ? 0 : resource().hashCode());
        hashCode = 31 * hashCode + ((useLongIds() == null) ? 0 : useLongIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdFormat)) {
            return false;
        }
        IdFormat other = (IdFormat) obj;
        if (other.deadline() == null ^ this.deadline() == null) {
            return false;
        }
        if (other.deadline() != null && !other.deadline().equals(this.deadline())) {
            return false;
        }
        if (other.resource() == null ^ this.resource() == null) {
            return false;
        }
        if (other.resource() != null && !other.resource().equals(this.resource())) {
            return false;
        }
        if (other.useLongIds() == null ^ this.useLongIds() == null) {
            return false;
        }
        if (other.useLongIds() != null && !other.useLongIds().equals(this.useLongIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deadline() != null) {
            sb.append("Deadline: ").append(deadline()).append(",");
        }
        if (resource() != null) {
            sb.append("Resource: ").append(resource()).append(",");
        }
        if (useLongIds() != null) {
            sb.append("UseLongIds: ").append(useLongIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Deadline":
            return Optional.of(clazz.cast(deadline()));
        case "Resource":
            return Optional.of(clazz.cast(resource()));
        case "UseLongIds":
            return Optional.of(clazz.cast(useLongIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, IdFormat> {
        /**
         * <p>
         * The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet
         * available for this resource type, this field is not returned.
         * </p>
         * 
         * @param deadline
         *        The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not
         *        yet available for this resource type, this field is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadline(Instant deadline);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resource
         *        The type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * Indicates whether longer IDs (17-character IDs) are enabled for the resource.
         * </p>
         * 
         * @param useLongIds
         *        Indicates whether longer IDs (17-character IDs) are enabled for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLongIds(Boolean useLongIds);
    }

    static final class BuilderImpl implements Builder {
        private Instant deadline;

        private String resource;

        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(IdFormat model) {
            deadline(model.deadline);
            resource(model.resource);
            useLongIds(model.useLongIds);
        }

        public final Instant getDeadline() {
            return deadline;
        }

        @Override
        public final Builder deadline(Instant deadline) {
            this.deadline = deadline;
            return this;
        }

        public final void setDeadline(Instant deadline) {
            this.deadline = deadline;
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Boolean getUseLongIds() {
            return useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        @Override
        public IdFormat build() {
            return new IdFormat(this);
        }
    }
}
