/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the ICMP type and code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IcmpTypeCode implements ToCopyableBuilder<IcmpTypeCode.Builder, IcmpTypeCode> {
    private final Integer code;

    private final Integer type;

    private IcmpTypeCode(BuilderImpl builder) {
        this.code = builder.code;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ICMP code. A value of -1 means all codes for the specified ICMP type.
     * </p>
     * 
     * @return The ICMP code. A value of -1 means all codes for the specified ICMP type.
     */
    public Integer code() {
        return code;
    }

    /**
     * <p>
     * The ICMP type. A value of -1 means all types.
     * </p>
     * 
     * @return The ICMP type. A value of -1 means all types.
     */
    public Integer type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((code() == null) ? 0 : code().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcmpTypeCode)) {
            return false;
        }
        IcmpTypeCode other = (IcmpTypeCode) obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (code() != null) {
            sb.append("Code: ").append(code()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.of(clazz.cast(code()));
        case "Type":
            return Optional.of(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, IcmpTypeCode> {
        /**
         * <p>
         * The ICMP code. A value of -1 means all codes for the specified ICMP type.
         * </p>
         * 
         * @param code
         *        The ICMP code. A value of -1 means all codes for the specified ICMP type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * The ICMP type. A value of -1 means all types.
         * </p>
         * 
         * @param type
         *        The ICMP type. A value of -1 means all types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Integer type);
    }

    static final class BuilderImpl implements Builder {
        private Integer code;

        private Integer type;

        private BuilderImpl() {
        }

        private BuilderImpl(IcmpTypeCode model) {
            code(model.code);
            type(model.type);
        }

        public final Integer getCode() {
            return code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        public final Integer getType() {
            return type;
        }

        @Override
        public final Builder type(Integer type) {
            this.type = type;
            return this;
        }

        public final void setType(Integer type) {
            this.type = type;
        }

        @Override
        public IcmpTypeCode build() {
            return new IcmpTypeCode(this);
        }
    }
}
