/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of GetReservedInstancesExchangeQuote.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetReservedInstancesExchangeQuoteResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetReservedInstancesExchangeQuoteResponse.Builder, GetReservedInstancesExchangeQuoteResponse> {
    private final String currencyCode;

    private final Boolean isValidExchange;

    private final Instant outputReservedInstancesWillExpireAt;

    private final String paymentDue;

    private final ReservationValue reservedInstanceValueRollup;

    private final List<ReservedInstanceReservationValue> reservedInstanceValueSet;

    private final ReservationValue targetConfigurationValueRollup;

    private final List<TargetReservationValue> targetConfigurationValueSet;

    private final String validationFailureReason;

    private GetReservedInstancesExchangeQuoteResponse(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.isValidExchange = builder.isValidExchange;
        this.outputReservedInstancesWillExpireAt = builder.outputReservedInstancesWillExpireAt;
        this.paymentDue = builder.paymentDue;
        this.reservedInstanceValueRollup = builder.reservedInstanceValueRollup;
        this.reservedInstanceValueSet = builder.reservedInstanceValueSet;
        this.targetConfigurationValueRollup = builder.targetConfigurationValueRollup;
        this.targetConfigurationValueSet = builder.targetConfigurationValueSet;
        this.validationFailureReason = builder.validationFailureReason;
    }

    /**
     * <p>
     * The currency of the transaction.
     * </p>
     * 
     * @return The currency of the transaction.
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
     * </p>
     * 
     * @return If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
     */
    public Boolean isValidExchange() {
        return isValidExchange;
    }

    /**
     * <p>
     * The new end date of the reservation term.
     * </p>
     * 
     * @return The new end date of the reservation term.
     */
    public Instant outputReservedInstancesWillExpireAt() {
        return outputReservedInstancesWillExpireAt;
    }

    /**
     * <p>
     * The total true upfront charge for the exchange.
     * </p>
     * 
     * @return The total true upfront charge for the exchange.
     */
    public String paymentDue() {
        return paymentDue;
    }

    /**
     * <p>
     * The cost associated with the Reserved Instance.
     * </p>
     * 
     * @return The cost associated with the Reserved Instance.
     */
    public ReservationValue reservedInstanceValueRollup() {
        return reservedInstanceValueRollup;
    }

    /**
     * <p>
     * The configuration of your Convertible Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The configuration of your Convertible Reserved Instances.
     */
    public List<ReservedInstanceReservationValue> reservedInstanceValueSet() {
        return reservedInstanceValueSet;
    }

    /**
     * <p>
     * The cost associated with the Reserved Instance.
     * </p>
     * 
     * @return The cost associated with the Reserved Instance.
     */
    public ReservationValue targetConfigurationValueRollup() {
        return targetConfigurationValueRollup;
    }

    /**
     * <p>
     * The values of the target Convertible Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The values of the target Convertible Reserved Instances.
     */
    public List<TargetReservationValue> targetConfigurationValueSet() {
        return targetConfigurationValueSet;
    }

    /**
     * <p>
     * Describes the reason why the exchange cannot be completed.
     * </p>
     * 
     * @return Describes the reason why the exchange cannot be completed.
     */
    public String validationFailureReason() {
        return validationFailureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((currencyCode() == null) ? 0 : currencyCode().hashCode());
        hashCode = 31 * hashCode + ((isValidExchange() == null) ? 0 : isValidExchange().hashCode());
        hashCode = 31 * hashCode
                + ((outputReservedInstancesWillExpireAt() == null) ? 0 : outputReservedInstancesWillExpireAt().hashCode());
        hashCode = 31 * hashCode + ((paymentDue() == null) ? 0 : paymentDue().hashCode());
        hashCode = 31 * hashCode + ((reservedInstanceValueRollup() == null) ? 0 : reservedInstanceValueRollup().hashCode());
        hashCode = 31 * hashCode + ((reservedInstanceValueSet() == null) ? 0 : reservedInstanceValueSet().hashCode());
        hashCode = 31 * hashCode + ((targetConfigurationValueRollup() == null) ? 0 : targetConfigurationValueRollup().hashCode());
        hashCode = 31 * hashCode + ((targetConfigurationValueSet() == null) ? 0 : targetConfigurationValueSet().hashCode());
        hashCode = 31 * hashCode + ((validationFailureReason() == null) ? 0 : validationFailureReason().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteResponse)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteResponse other = (GetReservedInstancesExchangeQuoteResponse) obj;
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.isValidExchange() == null ^ this.isValidExchange() == null) {
            return false;
        }
        if (other.isValidExchange() != null && !other.isValidExchange().equals(this.isValidExchange())) {
            return false;
        }
        if (other.outputReservedInstancesWillExpireAt() == null ^ this.outputReservedInstancesWillExpireAt() == null) {
            return false;
        }
        if (other.outputReservedInstancesWillExpireAt() != null
                && !other.outputReservedInstancesWillExpireAt().equals(this.outputReservedInstancesWillExpireAt())) {
            return false;
        }
        if (other.paymentDue() == null ^ this.paymentDue() == null) {
            return false;
        }
        if (other.paymentDue() != null && !other.paymentDue().equals(this.paymentDue())) {
            return false;
        }
        if (other.reservedInstanceValueRollup() == null ^ this.reservedInstanceValueRollup() == null) {
            return false;
        }
        if (other.reservedInstanceValueRollup() != null
                && !other.reservedInstanceValueRollup().equals(this.reservedInstanceValueRollup())) {
            return false;
        }
        if (other.reservedInstanceValueSet() == null ^ this.reservedInstanceValueSet() == null) {
            return false;
        }
        if (other.reservedInstanceValueSet() != null && !other.reservedInstanceValueSet().equals(this.reservedInstanceValueSet())) {
            return false;
        }
        if (other.targetConfigurationValueRollup() == null ^ this.targetConfigurationValueRollup() == null) {
            return false;
        }
        if (other.targetConfigurationValueRollup() != null
                && !other.targetConfigurationValueRollup().equals(this.targetConfigurationValueRollup())) {
            return false;
        }
        if (other.targetConfigurationValueSet() == null ^ this.targetConfigurationValueSet() == null) {
            return false;
        }
        if (other.targetConfigurationValueSet() != null
                && !other.targetConfigurationValueSet().equals(this.targetConfigurationValueSet())) {
            return false;
        }
        if (other.validationFailureReason() == null ^ this.validationFailureReason() == null) {
            return false;
        }
        if (other.validationFailureReason() != null && !other.validationFailureReason().equals(this.validationFailureReason())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (currencyCode() != null) {
            sb.append("CurrencyCode: ").append(currencyCode()).append(",");
        }
        if (isValidExchange() != null) {
            sb.append("IsValidExchange: ").append(isValidExchange()).append(",");
        }
        if (outputReservedInstancesWillExpireAt() != null) {
            sb.append("OutputReservedInstancesWillExpireAt: ").append(outputReservedInstancesWillExpireAt()).append(",");
        }
        if (paymentDue() != null) {
            sb.append("PaymentDue: ").append(paymentDue()).append(",");
        }
        if (reservedInstanceValueRollup() != null) {
            sb.append("ReservedInstanceValueRollup: ").append(reservedInstanceValueRollup()).append(",");
        }
        if (reservedInstanceValueSet() != null) {
            sb.append("ReservedInstanceValueSet: ").append(reservedInstanceValueSet()).append(",");
        }
        if (targetConfigurationValueRollup() != null) {
            sb.append("TargetConfigurationValueRollup: ").append(targetConfigurationValueRollup()).append(",");
        }
        if (targetConfigurationValueSet() != null) {
            sb.append("TargetConfigurationValueSet: ").append(targetConfigurationValueSet()).append(",");
        }
        if (validationFailureReason() != null) {
            sb.append("ValidationFailureReason: ").append(validationFailureReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCode()));
        case "IsValidExchange":
            return Optional.of(clazz.cast(isValidExchange()));
        case "OutputReservedInstancesWillExpireAt":
            return Optional.of(clazz.cast(outputReservedInstancesWillExpireAt()));
        case "PaymentDue":
            return Optional.of(clazz.cast(paymentDue()));
        case "ReservedInstanceValueRollup":
            return Optional.of(clazz.cast(reservedInstanceValueRollup()));
        case "ReservedInstanceValueSet":
            return Optional.of(clazz.cast(reservedInstanceValueSet()));
        case "TargetConfigurationValueRollup":
            return Optional.of(clazz.cast(targetConfigurationValueRollup()));
        case "TargetConfigurationValueSet":
            return Optional.of(clazz.cast(targetConfigurationValueSet()));
        case "ValidationFailureReason":
            return Optional.of(clazz.cast(validationFailureReason()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
        /**
         * <p>
         * The currency of the transaction.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
         * </p>
         * 
         * @param isValidExchange
         *        If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isValidExchange(Boolean isValidExchange);

        /**
         * <p>
         * The new end date of the reservation term.
         * </p>
         * 
         * @param outputReservedInstancesWillExpireAt
         *        The new end date of the reservation term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt);

        /**
         * <p>
         * The total true upfront charge for the exchange.
         * </p>
         * 
         * @param paymentDue
         *        The total true upfront charge for the exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentDue(String paymentDue);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * 
         * @param reservedInstanceValueRollup
         *        The cost associated with the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup);

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * 
         * @param reservedInstanceValueSet
         *        The configuration of your Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet);

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * 
         * @param reservedInstanceValueSet
         *        The configuration of your Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueSet(ReservedInstanceReservationValue... reservedInstanceValueSet);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * 
         * @param targetConfigurationValueRollup
         *        The cost associated with the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup);

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * 
         * @param targetConfigurationValueSet
         *        The values of the target Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet);

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * 
         * @param targetConfigurationValueSet
         *        The values of the target Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueSet(TargetReservationValue... targetConfigurationValueSet);

        /**
         * <p>
         * Describes the reason why the exchange cannot be completed.
         * </p>
         * 
         * @param validationFailureReason
         *        Describes the reason why the exchange cannot be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailureReason(String validationFailureReason);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Boolean isValidExchange;

        private Instant outputReservedInstancesWillExpireAt;

        private String paymentDue;

        private ReservationValue reservedInstanceValueRollup;

        private List<ReservedInstanceReservationValue> reservedInstanceValueSet;

        private ReservationValue targetConfigurationValueRollup;

        private List<TargetReservationValue> targetConfigurationValueSet;

        private String validationFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteResponse model) {
            currencyCode(model.currencyCode);
            isValidExchange(model.isValidExchange);
            outputReservedInstancesWillExpireAt(model.outputReservedInstancesWillExpireAt);
            paymentDue(model.paymentDue);
            reservedInstanceValueRollup(model.reservedInstanceValueRollup);
            reservedInstanceValueSet(model.reservedInstanceValueSet);
            targetConfigurationValueRollup(model.targetConfigurationValueRollup);
            targetConfigurationValueSet(model.targetConfigurationValueSet);
            validationFailureReason(model.validationFailureReason);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Boolean getIsValidExchange() {
            return isValidExchange;
        }

        @Override
        public final Builder isValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
            return this;
        }

        public final void setIsValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
        }

        public final Instant getOutputReservedInstancesWillExpireAt() {
            return outputReservedInstancesWillExpireAt;
        }

        @Override
        public final Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
            return this;
        }

        public final void setOutputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
        }

        public final String getPaymentDue() {
            return paymentDue;
        }

        @Override
        public final Builder paymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
            return this;
        }

        public final void setPaymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
        }

        public final ReservationValue.Builder getReservedInstanceValueRollup() {
            return reservedInstanceValueRollup != null ? reservedInstanceValueRollup.toBuilder() : null;
        }

        @Override
        public final Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup;
            return this;
        }

        public final void setReservedInstanceValueRollup(ReservationValue.BuilderImpl reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup != null ? reservedInstanceValueRollup.build() : null;
        }

        public final Collection<ReservedInstanceReservationValue.Builder> getReservedInstanceValueSet() {
            return reservedInstanceValueSet != null ? reservedInstanceValueSet.stream()
                    .map(ReservedInstanceReservationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copy(reservedInstanceValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceValueSet(ReservedInstanceReservationValue... reservedInstanceValueSet) {
            reservedInstanceValueSet(Arrays.asList(reservedInstanceValueSet));
            return this;
        }

        public final void setReservedInstanceValueSet(
                Collection<ReservedInstanceReservationValue.BuilderImpl> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copyFromBuilder(reservedInstanceValueSet);
        }

        public final ReservationValue.Builder getTargetConfigurationValueRollup() {
            return targetConfigurationValueRollup != null ? targetConfigurationValueRollup.toBuilder() : null;
        }

        @Override
        public final Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup;
            return this;
        }

        public final void setTargetConfigurationValueRollup(ReservationValue.BuilderImpl targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup != null ? targetConfigurationValueRollup.build()
                    : null;
        }

        public final Collection<TargetReservationValue.Builder> getTargetConfigurationValueSet() {
            return targetConfigurationValueSet != null ? targetConfigurationValueSet.stream()
                    .map(TargetReservationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copy(targetConfigurationValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurationValueSet(TargetReservationValue... targetConfigurationValueSet) {
            targetConfigurationValueSet(Arrays.asList(targetConfigurationValueSet));
            return this;
        }

        public final void setTargetConfigurationValueSet(
                Collection<TargetReservationValue.BuilderImpl> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copyFromBuilder(targetConfigurationValueSet);
        }

        public final String getValidationFailureReason() {
            return validationFailureReason;
        }

        @Override
        public final Builder validationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
            return this;
        }

        public final void setValidationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
        }

        @Override
        public GetReservedInstancesExchangeQuoteResponse build() {
            return new GetReservedInstancesExchangeQuoteResponse(this);
        }
    }
}
