/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for GetReservedInstanceExchangeQuote.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetReservedInstancesExchangeQuoteRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetReservedInstancesExchangeQuoteRequest.Builder, GetReservedInstancesExchangeQuoteRequest> {
    private final List<String> reservedInstanceIds;

    private final List<TargetConfigurationRequest> targetConfigurations;

    private GetReservedInstancesExchangeQuoteRequest(BuilderImpl builder) {
        this.reservedInstanceIds = builder.reservedInstanceIds;
        this.targetConfigurations = builder.targetConfigurations;
    }

    /**
     * <p>
     * The IDs of the Convertible Reserved Instances to exchange.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Convertible Reserved Instances to exchange.
     */
    public List<String> reservedInstanceIds() {
        return reservedInstanceIds;
    }

    /**
     * <p>
     * The configuration requirements of the Convertible Reserved Instances to exchange for your current Convertible
     * Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The configuration requirements of the Convertible Reserved Instances to exchange for your current
     *         Convertible Reserved Instances.
     */
    public List<TargetConfigurationRequest> targetConfigurations() {
        return targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservedInstanceIds() == null) ? 0 : reservedInstanceIds().hashCode());
        hashCode = 31 * hashCode + ((targetConfigurations() == null) ? 0 : targetConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteRequest)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteRequest other = (GetReservedInstancesExchangeQuoteRequest) obj;
        if (other.reservedInstanceIds() == null ^ this.reservedInstanceIds() == null) {
            return false;
        }
        if (other.reservedInstanceIds() != null && !other.reservedInstanceIds().equals(this.reservedInstanceIds())) {
            return false;
        }
        if (other.targetConfigurations() == null ^ this.targetConfigurations() == null) {
            return false;
        }
        if (other.targetConfigurations() != null && !other.targetConfigurations().equals(this.targetConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (reservedInstanceIds() != null) {
            sb.append("ReservedInstanceIds: ").append(reservedInstanceIds()).append(",");
        }
        if (targetConfigurations() != null) {
            sb.append("TargetConfigurations: ").append(targetConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstanceIds":
            return Optional.of(clazz.cast(reservedInstanceIds()));
        case "TargetConfigurations":
            return Optional.of(clazz.cast(targetConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
        /**
         * <p>
         * The IDs of the Convertible Reserved Instances to exchange.
         * </p>
         * 
         * @param reservedInstanceIds
         *        The IDs of the Convertible Reserved Instances to exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceIds(Collection<String> reservedInstanceIds);

        /**
         * <p>
         * The IDs of the Convertible Reserved Instances to exchange.
         * </p>
         * 
         * @param reservedInstanceIds
         *        The IDs of the Convertible Reserved Instances to exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceIds(String... reservedInstanceIds);

        /**
         * <p>
         * The configuration requirements of the Convertible Reserved Instances to exchange for your current Convertible
         * Reserved Instances.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration requirements of the Convertible Reserved Instances to exchange for your current
         *        Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations);

        /**
         * <p>
         * The configuration requirements of the Convertible Reserved Instances to exchange for your current Convertible
         * Reserved Instances.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration requirements of the Convertible Reserved Instances to exchange for your current
         *        Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(TargetConfigurationRequest... targetConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<String> reservedInstanceIds;

        private List<TargetConfigurationRequest> targetConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteRequest model) {
            reservedInstanceIds(model.reservedInstanceIds);
            targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstanceIds() {
            return reservedInstanceIds;
        }

        @Override
        public final Builder reservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceIds(String... reservedInstanceIds) {
            reservedInstanceIds(Arrays.asList(reservedInstanceIds));
            return this;
        }

        public final void setReservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
        }

        public final Collection<TargetConfigurationRequest.Builder> getTargetConfigurations() {
            return targetConfigurations != null ? targetConfigurations.stream().map(TargetConfigurationRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(TargetConfigurationRequest... targetConfigurations) {
            targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        public final void setTargetConfigurations(Collection<TargetConfigurationRequest.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public GetReservedInstancesExchangeQuoteRequest build() {
            return new GetReservedInstancesExchangeQuoteRequest(this);
        }
    }
}
