/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a flow log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FlowLog implements ToCopyableBuilder<FlowLog.Builder, FlowLog> {
    private final Instant creationTime;

    private final String deliverLogsErrorMessage;

    private final String deliverLogsPermissionArn;

    private final String deliverLogsStatus;

    private final String flowLogId;

    private final String flowLogStatus;

    private final String logGroupName;

    private final String resourceId;

    private final String trafficType;

    private FlowLog(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.deliverLogsErrorMessage = builder.deliverLogsErrorMessage;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.deliverLogsStatus = builder.deliverLogsStatus;
        this.flowLogId = builder.flowLogId;
        this.flowLogStatus = builder.flowLogStatus;
        this.logGroupName = builder.logGroupName;
        this.resourceId = builder.resourceId;
        this.trafficType = builder.trafficType;
    }

    /**
     * <p>
     * The date and time the flow log was created.
     * </p>
     * 
     * @return The date and time the flow log was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch logs throttling
     * has been applied for one or more network interfaces, or that you've reached the limit on the number of CloudWatch
     * Logs log groups that you can create. <code>Access error</code> indicates that the IAM role associated with the
     * flow log does not have sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates
     * an internal error.
     * </p>
     * 
     * @return Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch logs
     *         throttling has been applied for one or more network interfaces, or that you've reached the limit on the
     *         number of CloudWatch Logs log groups that you can create. <code>Access error</code> indicates that the
     *         IAM role associated with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
     *         <code>Unknown error</code> indicates an internal error.
     */
    public String deliverLogsErrorMessage() {
        return deliverLogsErrorMessage;
    }

    /**
     * <p>
     * The ARN of the IAM role that posts logs to CloudWatch Logs.
     * </p>
     * 
     * @return The ARN of the IAM role that posts logs to CloudWatch Logs.
     */
    public String deliverLogsPermissionArn() {
        return deliverLogsPermissionArn;
    }

    /**
     * <p>
     * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     * 
     * @return The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     */
    public String deliverLogsStatus() {
        return deliverLogsStatus;
    }

    /**
     * <p>
     * The flow log ID.
     * </p>
     * 
     * @return The flow log ID.
     */
    public String flowLogId() {
        return flowLogId;
    }

    /**
     * <p>
     * The status of the flow log (<code>ACTIVE</code>).
     * </p>
     * 
     * @return The status of the flow log (<code>ACTIVE</code>).
     */
    public String flowLogStatus() {
        return flowLogStatus;
    }

    /**
     * <p>
     * The name of the flow log group.
     * </p>
     * 
     * @return The name of the flow log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The ID of the resource on which the flow log was created.
     * </p>
     * 
     * @return The ID of the resource on which the flow log was created.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeString}.
     * </p>
     * 
     * @return The type of traffic captured for the flow log.
     * @see TrafficType
     */
    public TrafficType trafficType() {
        return TrafficType.fromValue(trafficType);
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeString}.
     * </p>
     * 
     * @return The type of traffic captured for the flow log.
     * @see TrafficType
     */
    public String trafficTypeString() {
        return trafficType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((deliverLogsErrorMessage() == null) ? 0 : deliverLogsErrorMessage().hashCode());
        hashCode = 31 * hashCode + ((deliverLogsPermissionArn() == null) ? 0 : deliverLogsPermissionArn().hashCode());
        hashCode = 31 * hashCode + ((deliverLogsStatus() == null) ? 0 : deliverLogsStatus().hashCode());
        hashCode = 31 * hashCode + ((flowLogId() == null) ? 0 : flowLogId().hashCode());
        hashCode = 31 * hashCode + ((flowLogStatus() == null) ? 0 : flowLogStatus().hashCode());
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((trafficTypeString() == null) ? 0 : trafficTypeString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowLog)) {
            return false;
        }
        FlowLog other = (FlowLog) obj;
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.deliverLogsErrorMessage() == null ^ this.deliverLogsErrorMessage() == null) {
            return false;
        }
        if (other.deliverLogsErrorMessage() != null && !other.deliverLogsErrorMessage().equals(this.deliverLogsErrorMessage())) {
            return false;
        }
        if (other.deliverLogsPermissionArn() == null ^ this.deliverLogsPermissionArn() == null) {
            return false;
        }
        if (other.deliverLogsPermissionArn() != null && !other.deliverLogsPermissionArn().equals(this.deliverLogsPermissionArn())) {
            return false;
        }
        if (other.deliverLogsStatus() == null ^ this.deliverLogsStatus() == null) {
            return false;
        }
        if (other.deliverLogsStatus() != null && !other.deliverLogsStatus().equals(this.deliverLogsStatus())) {
            return false;
        }
        if (other.flowLogId() == null ^ this.flowLogId() == null) {
            return false;
        }
        if (other.flowLogId() != null && !other.flowLogId().equals(this.flowLogId())) {
            return false;
        }
        if (other.flowLogStatus() == null ^ this.flowLogStatus() == null) {
            return false;
        }
        if (other.flowLogStatus() != null && !other.flowLogStatus().equals(this.flowLogStatus())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.trafficTypeString() == null ^ this.trafficTypeString() == null) {
            return false;
        }
        if (other.trafficTypeString() != null && !other.trafficTypeString().equals(this.trafficTypeString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (deliverLogsErrorMessage() != null) {
            sb.append("DeliverLogsErrorMessage: ").append(deliverLogsErrorMessage()).append(",");
        }
        if (deliverLogsPermissionArn() != null) {
            sb.append("DeliverLogsPermissionArn: ").append(deliverLogsPermissionArn()).append(",");
        }
        if (deliverLogsStatus() != null) {
            sb.append("DeliverLogsStatus: ").append(deliverLogsStatus()).append(",");
        }
        if (flowLogId() != null) {
            sb.append("FlowLogId: ").append(flowLogId()).append(",");
        }
        if (flowLogStatus() != null) {
            sb.append("FlowLogStatus: ").append(flowLogStatus()).append(",");
        }
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (trafficTypeString() != null) {
            sb.append("TrafficType: ").append(trafficTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.of(clazz.cast(creationTime()));
        case "DeliverLogsErrorMessage":
            return Optional.of(clazz.cast(deliverLogsErrorMessage()));
        case "DeliverLogsPermissionArn":
            return Optional.of(clazz.cast(deliverLogsPermissionArn()));
        case "DeliverLogsStatus":
            return Optional.of(clazz.cast(deliverLogsStatus()));
        case "FlowLogId":
            return Optional.of(clazz.cast(flowLogId()));
        case "FlowLogStatus":
            return Optional.of(clazz.cast(flowLogStatus()));
        case "LogGroupName":
            return Optional.of(clazz.cast(logGroupName()));
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "TrafficType":
            return Optional.of(clazz.cast(trafficTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, FlowLog> {
        /**
         * <p>
         * The date and time the flow log was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time the flow log was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch logs
         * throttling has been applied for one or more network interfaces, or that you've reached the limit on the
         * number of CloudWatch Logs log groups that you can create. <code>Access error</code> indicates that the IAM
         * role associated with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
         * <code>Unknown error</code> indicates an internal error.
         * </p>
         * 
         * @param deliverLogsErrorMessage
         *        Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch logs
         *        throttling has been applied for one or more network interfaces, or that you've reached the limit on
         *        the number of CloudWatch Logs log groups that you can create. <code>Access error</code> indicates that
         *        the IAM role associated with the flow log does not have sufficient permissions to publish to
         *        CloudWatch Logs. <code>Unknown error</code> indicates an internal error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverLogsErrorMessage(String deliverLogsErrorMessage);

        /**
         * <p>
         * The ARN of the IAM role that posts logs to CloudWatch Logs.
         * </p>
         * 
         * @param deliverLogsPermissionArn
         *        The ARN of the IAM role that posts logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverLogsPermissionArn(String deliverLogsPermissionArn);

        /**
         * <p>
         * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
         * </p>
         * 
         * @param deliverLogsStatus
         *        The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverLogsStatus(String deliverLogsStatus);

        /**
         * <p>
         * The flow log ID.
         * </p>
         * 
         * @param flowLogId
         *        The flow log ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogId(String flowLogId);

        /**
         * <p>
         * The status of the flow log (<code>ACTIVE</code>).
         * </p>
         * 
         * @param flowLogStatus
         *        The status of the flow log (<code>ACTIVE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogStatus(String flowLogStatus);

        /**
         * <p>
         * The name of the flow log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the flow log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The ID of the resource on which the flow log was created.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource on which the flow log was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of traffic captured for the flow log.
         * </p>
         * 
         * @param trafficType
         *        The type of traffic captured for the flow log.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(String trafficType);

        /**
         * <p>
         * The type of traffic captured for the flow log.
         * </p>
         * 
         * @param trafficType
         *        The type of traffic captured for the flow log.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(TrafficType trafficType);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String deliverLogsErrorMessage;

        private String deliverLogsPermissionArn;

        private String deliverLogsStatus;

        private String flowLogId;

        private String flowLogStatus;

        private String logGroupName;

        private String resourceId;

        private String trafficType;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowLog model) {
            creationTime(model.creationTime);
            deliverLogsErrorMessage(model.deliverLogsErrorMessage);
            deliverLogsPermissionArn(model.deliverLogsPermissionArn);
            deliverLogsStatus(model.deliverLogsStatus);
            flowLogId(model.flowLogId);
            flowLogStatus(model.flowLogStatus);
            logGroupName(model.logGroupName);
            resourceId(model.resourceId);
            trafficType(model.trafficType);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDeliverLogsErrorMessage() {
            return deliverLogsErrorMessage;
        }

        @Override
        public final Builder deliverLogsErrorMessage(String deliverLogsErrorMessage) {
            this.deliverLogsErrorMessage = deliverLogsErrorMessage;
            return this;
        }

        public final void setDeliverLogsErrorMessage(String deliverLogsErrorMessage) {
            this.deliverLogsErrorMessage = deliverLogsErrorMessage;
        }

        public final String getDeliverLogsPermissionArn() {
            return deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        public final String getDeliverLogsStatus() {
            return deliverLogsStatus;
        }

        @Override
        public final Builder deliverLogsStatus(String deliverLogsStatus) {
            this.deliverLogsStatus = deliverLogsStatus;
            return this;
        }

        public final void setDeliverLogsStatus(String deliverLogsStatus) {
            this.deliverLogsStatus = deliverLogsStatus;
        }

        public final String getFlowLogId() {
            return flowLogId;
        }

        @Override
        public final Builder flowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
            return this;
        }

        public final void setFlowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
        }

        public final String getFlowLogStatus() {
            return flowLogStatus;
        }

        @Override
        public final Builder flowLogStatus(String flowLogStatus) {
            this.flowLogStatus = flowLogStatus;
            return this;
        }

        public final void setFlowLogStatus(String flowLogStatus) {
            this.flowLogStatus = flowLogStatus;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getTrafficType() {
            return trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType.toString());
            return this;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public FlowLog build() {
            return new FlowLog(this);
        }
    }
}
