/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeInstanceStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstanceStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstanceStatusResponse.Builder, DescribeInstanceStatusResponse> {
    private final List<InstanceStatus> instanceStatuses;

    private final String nextToken;

    private DescribeInstanceStatusResponse(BuilderImpl builder) {
        this.instanceStatuses = builder.instanceStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more instance status descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instance status descriptions.
     */
    public List<InstanceStatus> instanceStatuses() {
        return instanceStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceStatuses() == null) ? 0 : instanceStatuses().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusResponse)) {
            return false;
        }
        DescribeInstanceStatusResponse other = (DescribeInstanceStatusResponse) obj;
        if (other.instanceStatuses() == null ^ this.instanceStatuses() == null) {
            return false;
        }
        if (other.instanceStatuses() != null && !other.instanceStatuses().equals(this.instanceStatuses())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceStatuses() != null) {
            sb.append("InstanceStatuses: ").append(instanceStatuses()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceStatuses":
            return Optional.of(clazz.cast(instanceStatuses()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstanceStatusResponse> {
        /**
         * <p>
         * One or more instance status descriptions.
         * </p>
         * 
         * @param instanceStatuses
         *        One or more instance status descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses);

        /**
         * <p>
         * One or more instance status descriptions.
         * </p>
         * 
         * @param instanceStatuses
         *        One or more instance status descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(InstanceStatus... instanceStatuses);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceStatus> instanceStatuses;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStatusResponse model) {
            instanceStatuses(model.instanceStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceStatus.Builder> getInstanceStatuses() {
            return instanceStatuses != null ? instanceStatuses.stream().map(InstanceStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copy(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(InstanceStatus... instanceStatuses) {
            instanceStatuses(Arrays.asList(instanceStatuses));
            return this;
        }

        public final void setInstanceStatuses(Collection<InstanceStatus.BuilderImpl> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copyFromBuilder(instanceStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceStatusResponse build() {
            return new DescribeInstanceStatusResponse(this);
        }
    }
}
