/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DeleteVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteVpcPeeringConnectionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteVpcPeeringConnectionResponse.Builder, DeleteVpcPeeringConnectionResponse> {
    private final Boolean returnValue;

    private DeleteVpcPeeringConnectionResponse(BuilderImpl builder) {
        this.returnValue = builder.returnValue;
    }

    /**
     * <p>
     * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     * </p>
     * 
     * @return Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     */
    public Boolean returnValue() {
        return returnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((returnValue() == null) ? 0 : returnValue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcPeeringConnectionResponse)) {
            return false;
        }
        DeleteVpcPeeringConnectionResponse other = (DeleteVpcPeeringConnectionResponse) obj;
        if (other.returnValue() == null ^ this.returnValue() == null) {
            return false;
        }
        if (other.returnValue() != null && !other.returnValue().equals(this.returnValue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (returnValue() != null) {
            sb.append("ReturnValue: ").append(returnValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReturnValue":
            return Optional.of(clazz.cast(returnValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteVpcPeeringConnectionResponse> {
        /**
         * <p>
         * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * </p>
         * 
         * @param returnValue
         *        Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean returnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcPeeringConnectionResponse model) {
            returnValue(model.returnValue);
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public DeleteVpcPeeringConnectionResponse build() {
            return new DeleteVpcPeeringConnectionResponse(this);
        }
    }
}
