/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeletePlacementGroup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeletePlacementGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeletePlacementGroupRequest.Builder, DeletePlacementGroupRequest> {
    private final String groupName;

    private DeletePlacementGroupRequest(BuilderImpl builder) {
        this.groupName = builder.groupName;
    }

    /**
     * <p>
     * The name of the placement group.
     * </p>
     * 
     * @return The name of the placement group.
     */
    public String groupName() {
        return groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePlacementGroupRequest)) {
            return false;
        }
        DeletePlacementGroupRequest other = (DeletePlacementGroupRequest) obj;
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeletePlacementGroupRequest> {
        /**
         * <p>
         * The name of the placement group.
         * </p>
         * 
         * @param groupName
         *        The name of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePlacementGroupRequest model) {
            groupName(model.groupName);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public DeletePlacementGroupRequest build() {
            return new DeletePlacementGroupRequest(this);
        }
    }
}
