/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteCustomerGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteCustomerGatewayRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteCustomerGatewayRequest.Builder, DeleteCustomerGatewayRequest> {
    private final String customerGatewayId;

    private DeleteCustomerGatewayRequest(BuilderImpl builder) {
        this.customerGatewayId = builder.customerGatewayId;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public String customerGatewayId() {
        return customerGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((customerGatewayId() == null) ? 0 : customerGatewayId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomerGatewayRequest)) {
            return false;
        }
        DeleteCustomerGatewayRequest other = (DeleteCustomerGatewayRequest) obj;
        if (other.customerGatewayId() == null ^ this.customerGatewayId() == null) {
            return false;
        }
        if (other.customerGatewayId() != null && !other.customerGatewayId().equals(this.customerGatewayId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (customerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(customerGatewayId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGatewayId":
            return Optional.of(clazz.cast(customerGatewayId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteCustomerGatewayRequest> {
        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String customerGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomerGatewayRequest model) {
            customerGatewayId(model.customerGatewayId);
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        @Override
        public DeleteCustomerGatewayRequest build() {
            return new DeleteCustomerGatewayRequest(this);
        }
    }
}
