/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcPeeringConnectionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateVpcPeeringConnectionResponse.Builder, CreateVpcPeeringConnectionResponse> {
    private final VpcPeeringConnection vpcPeeringConnection;

    private CreateVpcPeeringConnectionResponse(BuilderImpl builder) {
        this.vpcPeeringConnection = builder.vpcPeeringConnection;
    }

    /**
     * <p>
     * Information about the VPC peering connection.
     * </p>
     * 
     * @return Information about the VPC peering connection.
     */
    public VpcPeeringConnection vpcPeeringConnection() {
        return vpcPeeringConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcPeeringConnection() == null) ? 0 : vpcPeeringConnection().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionResponse)) {
            return false;
        }
        CreateVpcPeeringConnectionResponse other = (CreateVpcPeeringConnectionResponse) obj;
        if (other.vpcPeeringConnection() == null ^ this.vpcPeeringConnection() == null) {
            return false;
        }
        if (other.vpcPeeringConnection() != null && !other.vpcPeeringConnection().equals(this.vpcPeeringConnection())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpcPeeringConnection() != null) {
            sb.append("VpcPeeringConnection: ").append(vpcPeeringConnection()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringConnection":
            return Optional.of(clazz.cast(vpcPeeringConnection()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpcPeeringConnectionResponse> {
        /**
         * <p>
         * Information about the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnection
         *        Information about the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection);
    }

    static final class BuilderImpl implements Builder {
        private VpcPeeringConnection vpcPeeringConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionResponse model) {
            vpcPeeringConnection(model.vpcPeeringConnection);
        }

        public final VpcPeeringConnection.Builder getVpcPeeringConnection() {
            return vpcPeeringConnection != null ? vpcPeeringConnection.toBuilder() : null;
        }

        @Override
        public final Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection;
            return this;
        }

        public final void setVpcPeeringConnection(VpcPeeringConnection.BuilderImpl vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection != null ? vpcPeeringConnection.build() : null;
        }

        @Override
        public CreateVpcPeeringConnectionResponse build() {
            return new CreateVpcPeeringConnectionResponse(this);
        }
    }
}
