/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpcEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcEndpointResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateVpcEndpointResponse.Builder, CreateVpcEndpointResponse> {
    private final String clientToken;

    private final VpcEndpoint vpcEndpoint;

    private CreateVpcEndpointResponse(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.vpcEndpoint = builder.vpcEndpoint;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Information about the endpoint.
     * </p>
     * 
     * @return Information about the endpoint.
     */
    public VpcEndpoint vpcEndpoint() {
        return vpcEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((vpcEndpoint() == null) ? 0 : vpcEndpoint().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointResponse)) {
            return false;
        }
        CreateVpcEndpointResponse other = (CreateVpcEndpointResponse) obj;
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.vpcEndpoint() == null ^ this.vpcEndpoint() == null) {
            return false;
        }
        if (other.vpcEndpoint() != null && !other.vpcEndpoint().equals(this.vpcEndpoint())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (vpcEndpoint() != null) {
            sb.append("VpcEndpoint: ").append(vpcEndpoint()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "VpcEndpoint":
            return Optional.of(clazz.cast(vpcEndpoint()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpcEndpointResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Information about the endpoint.
         * </p>
         * 
         * @param vpcEndpoint
         *        Information about the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoint(VpcEndpoint vpcEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private VpcEndpoint vpcEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointResponse model) {
            clientToken(model.clientToken);
            vpcEndpoint(model.vpcEndpoint);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final VpcEndpoint.Builder getVpcEndpoint() {
            return vpcEndpoint != null ? vpcEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder vpcEndpoint(VpcEndpoint vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final void setVpcEndpoint(VpcEndpoint.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        @Override
        public CreateVpcEndpointResponse build() {
            return new CreateVpcEndpointResponse(this);
        }
    }
}
