/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateNetworkInterface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateNetworkInterfaceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateNetworkInterfaceResponse.Builder, CreateNetworkInterfaceResponse> {
    private final NetworkInterface networkInterface;

    private CreateNetworkInterfaceResponse(BuilderImpl builder) {
        this.networkInterface = builder.networkInterface;
    }

    /**
     * <p>
     * Information about the network interface.
     * </p>
     * 
     * @return Information about the network interface.
     */
    public NetworkInterface networkInterface() {
        return networkInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkInterface() == null) ? 0 : networkInterface().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfaceResponse)) {
            return false;
        }
        CreateNetworkInterfaceResponse other = (CreateNetworkInterfaceResponse) obj;
        if (other.networkInterface() == null ^ this.networkInterface() == null) {
            return false;
        }
        if (other.networkInterface() != null && !other.networkInterface().equals(this.networkInterface())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (networkInterface() != null) {
            sb.append("NetworkInterface: ").append(networkInterface()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterface":
            return Optional.of(clazz.cast(networkInterface()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateNetworkInterfaceResponse> {
        /**
         * <p>
         * Information about the network interface.
         * </p>
         * 
         * @param networkInterface
         *        Information about the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterface(NetworkInterface networkInterface);
    }

    static final class BuilderImpl implements Builder {
        private NetworkInterface networkInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfaceResponse model) {
            networkInterface(model.networkInterface);
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return networkInterface != null ? networkInterface.toBuilder() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public CreateNetworkInterfaceResponse build() {
            return new CreateNetworkInterfaceResponse(this);
        }
    }
}
