/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ConfirmProductInstance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfirmProductInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ConfirmProductInstanceRequest.Builder, ConfirmProductInstanceRequest> {
    private final String instanceId;

    private final String productCode;

    private ConfirmProductInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.productCode = builder.productCode;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The product code. This must be a product code that you own.
     * </p>
     * 
     * @return The product code. This must be a product code that you own.
     */
    public String productCode() {
        return productCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((productCode() == null) ? 0 : productCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmProductInstanceRequest)) {
            return false;
        }
        ConfirmProductInstanceRequest other = (ConfirmProductInstanceRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.productCode() == null ^ this.productCode() == null) {
            return false;
        }
        if (other.productCode() != null && !other.productCode().equals(this.productCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (productCode() != null) {
            sb.append("ProductCode: ").append(productCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "ProductCode":
            return Optional.of(clazz.cast(productCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ConfirmProductInstanceRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The product code. This must be a product code that you own.
         * </p>
         * 
         * @param productCode
         *        The product code. This must be a product code that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String productCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmProductInstanceRequest model) {
            instanceId(model.instanceId);
            productCode(model.productCode);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getProductCode() {
            return productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public ConfirmProductInstanceRequest build() {
            return new ConfirmProductInstanceRequest(this);
        }
    }
}
