/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to cancel a Spot instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelledSpotInstanceRequest implements
        ToCopyableBuilder<CancelledSpotInstanceRequest.Builder, CancelledSpotInstanceRequest> {
    private final String spotInstanceRequestId;

    private final String state;

    private CancelledSpotInstanceRequest(BuilderImpl builder) {
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the Spot instance request.
     * </p>
     * 
     * @return The ID of the Spot instance request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * The state of the Spot instance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CancelSpotInstanceRequestState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateString}.
     * </p>
     * 
     * @return The state of the Spot instance request.
     * @see CancelSpotInstanceRequestState
     */
    public CancelSpotInstanceRequestState state() {
        return CancelSpotInstanceRequestState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Spot instance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CancelSpotInstanceRequestState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateString}.
     * </p>
     * 
     * @return The state of the Spot instance request.
     * @see CancelSpotInstanceRequestState
     */
    public String stateString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((spotInstanceRequestId() == null) ? 0 : spotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelledSpotInstanceRequest)) {
            return false;
        }
        CancelledSpotInstanceRequest other = (CancelledSpotInstanceRequest) obj;
        if (other.spotInstanceRequestId() == null ^ this.spotInstanceRequestId() == null) {
            return false;
        }
        if (other.spotInstanceRequestId() != null && !other.spotInstanceRequestId().equals(this.spotInstanceRequestId())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(spotInstanceRequestId()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotInstanceRequestId":
            return Optional.of(clazz.cast(spotInstanceRequestId()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CancelledSpotInstanceRequest> {
        /**
         * <p>
         * The ID of the Spot instance request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        The ID of the Spot instance request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * The state of the Spot instance request.
         * </p>
         * 
         * @param state
         *        The state of the Spot instance request.
         * @see CancelSpotInstanceRequestState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancelSpotInstanceRequestState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Spot instance request.
         * </p>
         * 
         * @param state
         *        The state of the Spot instance request.
         * @see CancelSpotInstanceRequestState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancelSpotInstanceRequestState
         */
        Builder state(CancelSpotInstanceRequestState state);
    }

    static final class BuilderImpl implements Builder {
        private String spotInstanceRequestId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelledSpotInstanceRequest model) {
            spotInstanceRequestId(model.spotInstanceRequestId);
            state(model.state);
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CancelSpotInstanceRequestState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public CancelledSpotInstanceRequest build() {
            return new CancelledSpotInstanceRequest(this);
        }
    }
}
